/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.tasks;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.tasks.UserTaskRecordDao;
import com.xunlei.niux.data.vipgame.dto.tasks.UserTaskRecordDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;

public class UserTaskRecordDaoImpl
extends BaseDaoImpl
implements UserTaskRecordDao {
    @Override
    public List<UserTaskRecordDTO> getAllUserTaskRecord(String userId) {
        String sql = "select usertaskrecord.seqId,usertaskrecord.taskConfSeqId,usertaskrecord.expireTime,usertaskrecord.serverId,\nusertaskrecord.reward1Status,usertaskrecord.reward2Status,usertaskrecord.reward3Status,usertaskrecord.reward4Status,\ntaskgameconfig.gameId, taskgameconfig.picUrl,taskgameconfig.task1ref,taskgameconfig.task2ref,taskgameconfig.task3ref,taskgameconfig.task4ref,\ngames.gameNo,gameservers.fenQuNum,gameservers.fenQuName,gameservers.fenQuNickName\nfrom usertaskrecord\nleft join taskgameconfig on usertaskrecord.taskConfSeqId = taskgameconfig.seqId \nleft join games on taskgameconfig.gameId = games.gameId left join gameservers ON games.gameId = gameservers.gameId\nwhere usertaskrecord.userId = ? and usertaskrecord.expireTime > now() and taskgameconfig.status = 1 and games.status not in (0,2) and gameservers.openstatus not in (0,2);";
        final ArrayList<UserTaskRecordDTO> userTaskRecordDTOList = new ArrayList<UserTaskRecordDTO>();
        this.getJdbcTemplate().query(sql, new Object[]{userId}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                UserTaskRecordDTO recordDTO = new UserTaskRecordDTO();
                recordDTO.setSeqId(resultSet.getLong("seqId"));
                recordDTO.setTaskConfSeqId(resultSet.getLong("taskConfSeqId"));
                recordDTO.setExpireTime(resultSet.getString("expireTime"));
                recordDTO.setServerId(resultSet.getString("serverId"));
                recordDTO.setReward1Status(resultSet.getBoolean("reward1Status"));
                recordDTO.setReward2Status(resultSet.getBoolean("reward2Status"));
                recordDTO.setReward3Status(resultSet.getBoolean("reward3Status"));
                recordDTO.setReward4Status(resultSet.getBoolean("reward4Status"));
                recordDTO.setGameId(resultSet.getString("gameId"));
                recordDTO.setPicUrl(resultSet.getString("picUrl"));
                recordDTO.setTask1ref(resultSet.getInt("task1ref"));
                recordDTO.setTask2ref(resultSet.getInt("task2ref"));
                recordDTO.setTask3ref(resultSet.getInt("task3ref"));
                recordDTO.setTask4ref(resultSet.getInt("task4ref"));
                recordDTO.setGameNo(resultSet.getString("gameNo"));
                recordDTO.setFenQuNum(resultSet.getInt("fenQuNum"));
                recordDTO.setFenQuName(resultSet.getString("fenQuName"));
                recordDTO.setFenQuNickName(resultSet.getString("fenQuNickName"));
                userTaskRecordDTOList.add(recordDTO);
            }
        });
        return userTaskRecordDTOList;
    }
}

