package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.AdviceTypeEnum;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameContent;

/**
 * 公告
 *
 * @author lisu
 * @date 2013-1-10
 * @Descripter:
 */
public interface AdviceBo {
    List<Advice> find(Advice advice, int pageNo, int pageSize);
    Advice findAdviceById(long seqId);
    int count(Advice advice);
    void update(Advice advice);
    void insert(Advice advice);
    void delete(Long seqId);
    List<Advice> findAdvice(Advice advice, Page page);
    public void execute(String sql, List<Object> list);
    public List executeQuery(Class class1, String sql, List list);

    /**
     * 获取AdviceType以publishDate desc排序的所有adviceList
     *
     * @param adviceTypeEnum
     * @return
     */
    public List<Advice> getAllAdviceByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum);

    /**
     * 获取AdviceType以publishDate desc排序的前limit个adviceList
     *
     * @param adviceTypeEnum
     * @param limit
     * @return
     */
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, int limit);

    /**
     * 获取AdviceType下，类型为platform，以publishDate desc排序的前limit个adviceList
     *
     * @param adviceTypeEnum
     * @param platformno
     *            gonggao，huodong等
     * @param limit
     * @return
     */
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, String platformno, int limit);

    /**
     * 获取最近一天更新（添加）的文章（活动公告等）
     *
     * @return
     */
    List<Advice> getRecentlyUpdatedAdvices();

    /**
     * 保存及返回id
     * @param advice
     * @return
     */
    Long insertReturnId(Advice advice);

    /**
     * 更新显示顺序默认值，去红粗时间失效时
     * @param gameId
     */
    void updateDisplayOrderDefault(String gameId);


}
