package com.xunlei.niux.data.vipgame.vo;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;

/**
 * 推广信息定时切量bean
 * @author hezhong
 */
@Table(tableName="spreadinfotime",pkFieldName="seqid",pkFieldAssign=true)
public class SpreadInfoTime {

    private Integer seqid;

    /**
     * 推广信息ID
     */
    private Integer spreadid;

    /**
     * 切量日期, 格式为：yyyy-MM-dd HH:mm:ss
     */
    private String spreaddate;

    /**
     * 是否已经切量
     * 默认值为:否
     */
    private Boolean isinvalid;

    private String jumpurl;

    private String remark;

    @Column(columnName="spreaddate",isWhereColumn=true,operator= Operator.GE)
    private String fromSpreaddate;

    @Column(columnName="spreaddate",isWhereColumn=true,operator=Operator.LT)
    private String toSpreaddate;

    public String getFromSpreaddate() {
        return fromSpreaddate;
    }

    public void setFromSpreaddate(String fromSpreaddate) {
        this.fromSpreaddate = fromSpreaddate;
    }

    public String getToSpreaddate() {
        return toSpreaddate;
    }

    public void setToSpreaddate(String toSpreaddate) {
        this.toSpreaddate = toSpreaddate;
    }

    public Integer getSeqid() {
        return seqid;
    }

    public void setSeqid(Integer seqid) {
        this.seqid = seqid;
    }

    public Integer getSpreadid() {
        return spreadid;
    }

    public void setSpreadid(Integer spreadid) {
        this.spreadid = spreadid;
    }

    public String getSpreaddate() {
        return spreaddate;
    }

    public void setSpreaddate(String spreaddate) {
        this.spreaddate = spreaddate;
    }

    public Boolean getIsinvalid() {
        return isinvalid;
    }

    public void setIsinvalid(Boolean isinvalid) {
        this.isinvalid = isinvalid;
    }

    public String getJumpurl() {
        return jumpurl;
    }

    public void setJumpurl(String jumpurl) {
        this.jumpurl = jumpurl;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
