package com.xunlei.niux.data.vipgame.dao.customerService;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerDTO;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerSumDTO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangya on 2016/12/22.
 */
public class CsCallerDaoImpl extends BaseDaoImpl implements CsCallerDao {

    @Override
    public List<CsCallerDTO> getCsCallerDTO(CsCallerDTO csCallerDTO, Page page) {
        List<Object> list = new ArrayList<Object>();
        String sql = "SELECT cc.seqid,cc.accept,cc.answer,cc.demandId,cc.editBy,cc.editTime,cc.feedback,cc.lastCallTime,cc.orderNo, " +
                "cc.phone,cc.userId,cc.status,ccd.demandName,ccd.backflow,ccd.beginTime,ccd.endTime,DATEDIFF(NOW(),cc.lastCallTime) AS days, " +
                "ccd.gameId,ccd.inputBy,ccd.total,ccd.inputTime,ccd.remark,ccd.type,ccd.rule,'' as  fromBeginTime,'' as toBeginTime, " +
                "ccdata.loginTime,ccdata.payTotal,'' as toSeqid, '' as fromSeqid \n" +
                "from cs_caller cc\n" +
                "LEFT JOIN cs_caller_demand ccd on cc.demandId = ccd.seqid \n" +
                "LEFT JOIN cs_caller_data ccdata on ccdata.demandId = ccd.seqid and ccdata.userId = cc.userId \n" +
                "where 1= 1 "+getCondition(csCallerDTO,list);

        if(page!=null){
            if(page.getPageNo()<1){
                page.setPageNo(1);
            }
            sql += " order by ccd.beginTime asc,ccd.seqid asc, cc.orderNo asc ";
            sql += " limit "+(page.getPageNo()-1)*page.getPageSize()+","+page.getPageSize();
        }
        return findBySql(CsCallerDTO.class, sql, list);
    }

    @Override
    public int getCsCallerDTOCount(CsCallerDTO csCallerDTO) {
        List<Object> list = new ArrayList<Object>();
        String sql = "SELECT count(*) \n" +
                "from cs_caller cc\n" +
                "LEFT JOIN cs_caller_demand ccd on cc.demandId = ccd.seqid \n" +
                "where 1= 1 "+getCondition(csCallerDTO,list);
        return getJdbcTemplate().queryForInt( sql, list.toArray());
    }

    private String getCondition(CsCallerDTO csCallerDTO,List<Object> param){
        StringBuffer stringBuffer = new StringBuffer();
        if(csCallerDTO==null){
            return stringBuffer.toString();
        }
        if(csCallerDTO.getSeqid()!=null&&csCallerDTO.getSeqid().longValue()>0){
            stringBuffer.append(" and cc.seqid = ? ");
            param.add(csCallerDTO.getSeqid());
        }

        if(csCallerDTO.getDemandId()!=null&&csCallerDTO.getDemandId().longValue()>0){
            stringBuffer.append(" and cc.demandId = ? ");
            param.add(csCallerDTO.getDemandId());
        }

        if(csCallerDTO.getUserId()!=null&&csCallerDTO.getUserId().longValue()>0){
            stringBuffer.append(" and cc.userId = ? ");
            param.add(csCallerDTO.getUserId());
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getGameId())){
            stringBuffer.append(" and ccd.gameId = ? ");
            param.add(csCallerDTO.getGameId());
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getDemandName())){
            stringBuffer.append(" and ccd.demandName like ?");
            param.add("%"+csCallerDTO.getDemandName()+"%");
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getFromBeginTime())){
            stringBuffer.append(" and ccd.beginTime >= ? ");
            param.add(csCallerDTO.getFromBeginTime());
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getToBeginTime())){
            stringBuffer.append(" and ccd.beginTime <= ? ");
            param.add(csCallerDTO.getToBeginTime());
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getPhone())){
            stringBuffer.append(" and cc.phone = ? ");
            param.add(csCallerDTO.getPhone());
        }

        if(StringUtils.isNotEmpty(csCallerDTO.getEditBy())){
            stringBuffer.append(" and cc.editBy = ? ");
            param.add(csCallerDTO.getEditBy());
        }

        if(csCallerDTO.getAnswer()!=null&&csCallerDTO.getAnswer().intValue()>-1){
            stringBuffer.append(" and cc.answer = ? ");
            param.add(csCallerDTO.getAnswer());
        }

        if(csCallerDTO.getAccept()!=null&&csCallerDTO.getAccept().intValue()>-1){
            stringBuffer.append(" and cc.accept = ? ");
            param.add(csCallerDTO.getAccept());
        }

        if(csCallerDTO.getStatus()!=null&&csCallerDTO.getStatus().intValue()>-1){
            stringBuffer.append(" and cc.status = ? ");
            param.add(csCallerDTO.getStatus());
        }

        if(csCallerDTO.getFromSeqid()!=null&&csCallerDTO.getFromSeqid().intValue()>0){
            stringBuffer.append(" and cc.orderNo >= ? ");
            param.add(csCallerDTO.getFromSeqid());
        }

        if(csCallerDTO.getToSeqid()!=null&&csCallerDTO.getToSeqid().intValue()>0){
            stringBuffer.append(" and cc.orderNo <= ? ");
            param.add(csCallerDTO.getToSeqid());
        }

        return stringBuffer.toString();
    }

    @Override
    public String getLastCallTime(Long userId) {
        String sql = "select max(editTime) as lastCallTime from cs_caller where userId = ? ";
        List<Object> list = new ArrayList<Object>();
        list.add(userId);
        Map<String, Object> forMap = findForMap(sql, list);
        return String.valueOf(forMap.get("lastCallTime"));
    }


    @Override
    public List<CsCallerSumDTO> getCsCallerSumDTO(CsCallerSumDTO csCallerSumDTO, Page page) {
        List<Object> param = new ArrayList<Object>();
        String sql = "select ccd.beginTime , ccd.endTime,ccd.demandName,ccd.seqid as demandid,c1.answerCount,c2.touchCount,c3.acceptCount,c4.paySum,c5.loginCount,\n" +
                "0.0 as answerPrecent , 0.0 as acceptPrecent , 0.0 as successPrecent ,ccd.gameId,ccd.rule,ccd.backflow,ccd.total,ccd.remark,'' as fromBeginTime , '' as toBeginTime ," +
                " ccd.type,ccd.inputTime,ccd.inputBy \n" +
                "from cs_caller_demand  ccd \n" +
                "LEFT JOIN (SELECT demandid,count(*) as answerCount from cs_caller WHERE answer =1 and status = 2 ) c1 on c1.demandid = ccd.seqid\n" +
                "LEFT JOIN (SELECT demandid,count(*) as touchCount from cs_caller WHERE status = 2 and status = 2 ) c2 on c2.demandid = ccd.seqid\n" +
                "LEFT JOIN (SELECT demandid,count(*) as acceptCount from cs_caller WHERE accept =1 and status = 2) c3 on c3.demandid = ccd.seqid\n" +
                "LEFT JOIN (SELECT incc.demandid,sum(paytotal) as paySum from cs_caller_data inccd " +
                " LEFT JOIN cs_caller incc on inccd.demandId = incc.demandId and inccd.userId = incc.userId " +
                "WHERE incc.status=2 and paytotal > 0  ) c4 on c4.demandid = ccd.seqid\n" +
                "LEFT JOIN (SELECT incc.demandid,count(*) as loginCount from cs_caller_data inccd " +
                " LEFT JOIN cs_caller incc on inccd.demandId = incc.demandId and inccd.userId = incc.userId " +
                "WHERE incc.status=2 and loginTime > 0) c5 on c5.demandid = ccd.seqid\n" +
                "where 1 = 1 " + getCsCallerSumCondition(csCallerSumDTO,param);

        if(page!=null){
            if(page.getPageNo()<1){
                page.setPageNo(1);
            }

            sql += " order by ccd.beginTime desc ";
            sql += " limit "+(page.getPageNo()-1)*page.getPageSize()+","+page.getPageSize();
        }
        List<CsCallerSumDTO> sumDTOs = findBySql(CsCallerSumDTO.class, sql, param);
        if(CollectionUtils.isEmpty(sumDTOs)){
            return sumDTOs;
        }

        for(CsCallerSumDTO dto : sumDTOs){

            if(dto.getTouchCount()==0){

                dto.setAnswerPrecent(0.0);
                dto.setAcceptPrecent(0.0);
                dto.setSuccessPrecent(0.0);

            }else {
                BigDecimal answerCount = new BigDecimal(dto.getAnswerCount()==null?0:dto.getAnswerCount());
                BigDecimal touchCount = new BigDecimal(dto.getTouchCount()==null?0:dto.getTouchCount());
                BigDecimal acceptCount = new BigDecimal(dto.getAcceptCount()==null?0:dto.getAcceptCount());
                BigDecimal loginCount = new BigDecimal(dto.getLoginCount()==null?0:dto.getLoginCount());

                dto.setAnswerPrecent(answerCount.multiply(new BigDecimal(100)).divide(touchCount,2,BigDecimal.ROUND_HALF_UP).doubleValue());
                dto.setAcceptPrecent(acceptCount.multiply(new BigDecimal(100)).divide(touchCount,2,BigDecimal.ROUND_HALF_UP).doubleValue());
                dto.setSuccessPrecent(loginCount.multiply(new BigDecimal(100)).divide(answerCount,2,BigDecimal.ROUND_HALF_UP).doubleValue());
            }

        }

        return sumDTOs;
    }


    private String getCsCallerSumCondition(CsCallerSumDTO callerSumDTO,List<Object> param){
        if(callerSumDTO == null){
            return "";
        }
        StringBuffer buffer = new StringBuffer();

        if(callerSumDTO.getDemandId()!=null&&callerSumDTO.getDemandId()>0){
            buffer.append(" and ccd.seqid = ? ");
            param.add(callerSumDTO.getDemandId());
        }

        if(StringUtils.isNotEmpty(callerSumDTO.getGameId())){
            buffer.append(" and ccd.gameId = ? ");
            param.add(callerSumDTO.getGameId());
        }

        if(StringUtils.isNotEmpty(callerSumDTO.getFromBeginTime())){
            buffer.append(" and ccd.beginTime >= ? ");
            param.add(callerSumDTO.getFromBeginTime());
        }

        if(StringUtils.isNotEmpty(callerSumDTO.getToBeginTime())){
            buffer.append(" and ccd.beginTime <= ? ");
            param.add(callerSumDTO.getToBeginTime());
        }

        if(StringUtils.isNotEmpty(callerSumDTO.getDemandName())){
            buffer.append(" and ccd.demandName like ? ");
            param.add("%"+callerSumDTO.getDemandName()+"%");
        }

        return buffer.toString();
    }

    @Override
    public int getCsCallerSumDTOCount(CsCallerSumDTO csCallerSumDTO) {
        List<Object> param = new ArrayList<Object>();
        String sql = "select count(*) from cs_caller_demand ccd  where 1=1 "+getCsCallerSumCondition(csCallerSumDTO,param);

        return getJdbcTemplate().queryForInt( sql, param.toArray());
    }

    @Override
    public void deleteCsCallDemandBatch(Long... seqids) {
        String seqIdStr = StringUtils.join(seqids,",");
        String ccsql = "delete from cs_caller where demandId in  ( "+seqIdStr+" )";
        getJdbcTemplate().execute(ccsql);
        String ccdsql = "delete from cs_caller_demand where seqId in ("+seqIdStr+")";
        getJdbcTemplate().execute(ccdsql);
    }

    @Override
    public void updateLastCallTimeByUid(Long uid,String time) {
        String sql = "update cs_caller set  lastCallTime = '"+time+"' where userid = "+uid+" and status = 0  ";
        getJdbcTemplate().update(sql);
    }
}
