package com.xunlei.niux.data.vipgame.bo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

import javax.annotation.Resource;

import com.ferret.common.dao.presql.Insert;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;

public class BaseSoImpl extends BaseDaoImpl implements BaseSo{

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public <T> T findById(Class<T> clazz,Number id){
		return baseDao.findById(clazz,id);
	}
	public <T> T findById(Class<T> clazz,String id){
		return baseDao.findById(clazz, id);
	}
	public <T> T findObject(T queryObject){
		Page page=new Page();
		List<T> list= findObjects(queryObject,page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	@SuppressWarnings("unchecked")
	public <T> List<T> findObjects(T queryObject,Page page){
		return (List<T>) baseDao.findByObject(queryObject.getClass(),queryObject,page);
	}
	public <T> void addObject(T object){
		baseDao.insert(object);
	}
	public <T> void deleteById(Class<T> clazz,Number id){
		baseDao.deleteById(clazz, id);
	}
	public <T> void deleteById(Class<T> clazz,String id){
		baseDao.deleteById(clazz, id);
	}
	public <T> void updateObjectById(T object){
		baseDao.updateById(object);
	}
	public <T> int countObject(T object){
		return baseDao.count(object);
	}
	public List executeQuery(Class class1, String sql, List list) {       
		return baseDao.executeQuery(class1, sql, list);
	}
	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}

	@Override
	public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) {
		@SuppressWarnings("unchecked")
		List<Object> list = getJdbcTemplate().queryForList(sql, args, elementType);
		List<T> result = new LinkedList<T>();
		if(list != null) {
			for(Object obj : list) {
				result.add(elementType.cast(obj));
			}
		}
		return result;
	}

	@Override
	public void execute(String presql, List<Object> paramList) {
		baseDao.execute(presql, paramList);
	}

	public long insertReturnId(Object obj) {
		Insert insert = new Insert(obj);
		final String sql = insert.getPreSql();
		final List paramList = insert.getParamsList();
		GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
		this.getJdbcTemplate().update(new PreparedStatementCreator() {
			public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
				PreparedStatement ps = con.prepareStatement(sql, 1);

				for(int i = 0; i < paramList.size(); ++i) {
					ps.setObject(i + 1, paramList.get(i));
				}

				return ps;
			}
		}, keyHolder);
		return keyHolder.getKey().longValue();
	}
}
