package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.niux.data.vipgame.enums.AdviceTypeEnum;
import com.xunlei.niux.data.vipgame.vo.Advice;

public class AdviceBoImpl implements AdviceBo {
//    private BaseDao baseDao;
    private BaseSo baseSo;

    public BaseSo getBaseSo() {
        return baseSo;
    }

    public void setBaseSo(BaseSo baseSo) {
        this.baseSo = baseSo;
    }

//    public BaseDao getBaseDao() {
//        return baseDao;
//    }
//
//    public void setBaseDao(BaseDao baseDao) {
//        this.baseDao = baseDao;
//    }

    public List<Advice> find(Advice advice, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("displayOrder", OrderType.ESC);
        page.addOrder("inputTime", OrderType.DESC);
        return baseSo.findObjects(advice, page);
    }

    public List<Advice> findAdvice(Advice advice, Page page) {
        return baseSo.findObjects(advice, page);
    }

    public Advice findAdviceById(long seqId) {
        return baseSo.findById(Advice.class, seqId);
    }

    public int count(Advice advice) {
        return baseSo.countObject(advice);
    }

    public void update(Advice advice) {
        baseSo.updateObjectById(advice);
    }

    public void insert(Advice advice) {
        baseSo.insertReturnId(advice);
    }

    public void delete(Long seqId) {
        baseSo.deleteById(Advice.class, seqId);
    }

    public void execute(String sql, List<Object> list) {
        baseSo.execute(sql, list);

    }

    public List executeQuery(Class class1, String sql, List list) {
        return baseSo.executeQuery(class1, sql, list);
    }

    @Override
    public List<Advice> getAllAdviceByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum) {
        return getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", 0);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, int limit) {
        return getAdviceListByAdviceTypeOrderByPublishDateDesc(adviceTypeEnum, "", limit);
    }

    @Override
    public List<Advice> getAdviceListByAdviceTypeOrderByPublishDateDesc(AdviceTypeEnum adviceTypeEnum, String platformno, int limit) {
        Advice query = new Advice();
        query.setAdviceType(adviceTypeEnum.getValue());
        if (StringUtils.isNotEmpty(platformno)) {
            query.setPlatformno(platformno);
        }

        Page page = new Page();
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        page.addOrder("publishDate", OrderType.DESC);
        return baseSo.findObjects( query, page);
    }

    @Override
    public List<Advice> getRecentlyUpdatedAdvices() {
        String sql = "select * from advice where inputTime >= '" + DatetimeUtil.yesterday() + " 20:00:00' order by gameid, inputTime";
        baseSo.execute(sql,null);
        return baseSo.queryForList(sql,null,Advice.class);
    }

    @Override
    public Long insertReturnId(Advice advice) {
        return baseSo.insertReturnId(advice);
    }
}
