package com.xunlei.niux.data.vipgame.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.log4j.Logger;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;


public class JRedisProxy {
	private static JRedisProxy jRedisProxy = new JRedisProxy();
	private static Logger logger = Logger.getLogger("redisLoger");

	public static JRedisProxy getInstance() {
		return jRedisProxy;
	}

	private Properties config = new Properties();
	private JedisPool pool;

	private JRedisProxy() {

		try {
			System.out.println("jredis system连接 初始化");
			config.load(JRedisProxy.class.getClassLoader()
					.getResourceAsStream("jredis.properties"));
			JedisPoolConfig poolConfig = new JedisPoolConfig();
			//poolConfig.setMaxActive(Integer.parseInt(config.getProperty("maxActive", "1000")));
			poolConfig.setMaxTotal(Integer.parseInt(config.getProperty("maxActive", "1000")));
			poolConfig.setMaxIdle(Integer.parseInt(config.getProperty("maxIdle", "30")));
			//poolConfig.setMaxWait(Integer.parseInt(config.getProperty("maxWait", "1000")));
			poolConfig.setMaxWaitMillis(Integer.parseInt(config.getProperty("maxWait", "1000")));
			poolConfig.setTestOnBorrow(false);
			poolConfig.setTestOnReturn(false);
			pool = new JedisPool(poolConfig, config.getProperty("host"),
					Integer.parseInt(config.getProperty("port", "6379")));
			/*
			 * System.out.println("jredis连接池初始化成功：host=" +
			 * config.getProperty("host") + ",ports=" +
			 * Integer.parseInt(config.getProperty("port", "6379")) +
			 * ",maxActive=" + Integer.parseInt(config.getProperty("maxActive",
			 * "50")) + ",maxIdle=" +
			 * Integer.parseInt(config.getProperty("maxIdle", "10")));
			 */
		} catch (Exception e) {
			System.out.println("jredis system连接池初始化失败");
			e.printStackTrace();
			// logger.info("jredis连接池初始化失败", e);
		}
	}

	public boolean set(String key, String value, int seconds) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.setex(key, seconds, value);
			return true;
		} catch (Exception e) {
			logger.info("jredisSet异常：key=" + key + ",value=" + value
					+ ",seconds=" + seconds, e);

		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}
		return false;
	}
	
	public boolean set(String key, String value) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.set(key, value);
			return true;
		} catch (Exception e) {
			logger.info("jredisSet异常：key=" + key + ",value=" + value, e);
		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}
		return false;
	}

	public String get(String key) {
		String value = null;
		Jedis jedis = null;
		try {
	
			jedis = pool.getResource();
			value=jedis.get(key);

		} catch (Exception e) {
			logger.info("jredisget异常：key=" + key + ",value=" + value, e);

		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}
		return value;
	}

	public void del(String key) {

		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.del(key);

		} catch (Exception e) {
			logger.info("jredisdel异常：key=" + key, e);

		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}

	}
	
	public void delByPrefix(String prefix) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			Set<String> keys = jedis.keys(prefix + "*");
	        for(String key : keys){  
	            jedis.del(key);  
	        }  
		} catch (Exception e) {
			logger.error("jredisdel异常：prefix=" + prefix, e);
		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}
	}

	public boolean exists(String key) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			long ttl=jedis.ttl(key);
			if(ttl>0){
				return true;
			}else{
				return false;
			}
					
		} catch (Exception e) {
			logger.info("jredisEsists异常：key=" + key, e);

		} finally {
			if (jedis != null) {
				//pool.returnBrokenResource(jedis);
				jedis.close();
			}
		}
		return false;
	}

	public void test(){
		 try {
		Jedis	jedis = pool.getResource();
		if(this.exists("000120_1_ROLE_FIGHT")){
        System.out.println(true);// 检查key是否存在   
        }
		//pool.returnBrokenResource(jedis);
		jedis.close();
        }catch( Exception e){
        	e.printStackTrace();
        }

	}

	public static void main(String[] args) {
		JRedisProxy.getInstance().test();
	}
	

		          
    public  byte[] serialize(List<Object> list) throws Exception{  
         if (list == null) {  
             throw new NullPointerException("Can't serialize null");  
         }  
        byte[] rv=null;  
        ByteArrayOutputStream bos = null;  
        ObjectOutputStream os = null;  
         try {  
             bos = new ByteArrayOutputStream();  
             os = new ObjectOutputStream(bos);  
             for(Object obj : list){  
                 os.writeObject(obj);  
             }  
             os.writeObject(null);  
             os.close();  
             bos.close();  
             rv = bos.toByteArray();  
         } catch (IOException e) {  
             throw new IllegalArgumentException("Non-serializable object", e);  
         } finally {  
             try{
            	 if(os != null){
            		 os.close();
            		 os = null;
            	 }
            	if(bos != null){
            		bos.close();
            		bos = null;
            	}
             }catch(Exception e){
            	 e.printStackTrace();
             }		                
         }  
         return rv;  
     }  

    
    public  List<Object> deserialize(byte[] in) throws Exception{  
            List<Object> list = new ArrayList<Object>();  
            ByteArrayInputStream bis = null;  
            ObjectInputStream is = null;  
	         try {  
	                if(in != null) {  
	                    bis=new ByteArrayInputStream(in);  
	                    is=new ObjectInputStream(bis);  
	                    while (true) {  
	                    	Object user = (Object) is.readObject();  
	                        if(user == null){  
	                            break;  
	                       }else{  
	                            list.add(user);  
	                       }  
	                    }  
	                    is.close();  
	                    bis.close();  
	                }  
	            } catch (IOException e) {  
	               throw new Exception("Caught CNFE decoding %d bytes of data");
	            } catch (ClassNotFoundException e) {  
	                throw new Exception("Caught CNFE decoding %d bytes of data");
	            } finally {  
	            	 try{
	                	 if(is != null){
	                		 is.close();
	                		 is = null;
	                	 }
	                	if(bis != null){
	                		bis.close();
	                		bis = null;
	                	}
	                 }catch(Exception e){
	                	 e.printStackTrace();
	                 }		        
	            }  
	            return list;  
	        }  

}
