/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.customerService;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.customerService.CsCallerDao;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerDTO;
import com.xunlei.niux.data.vipgame.dto.customerService.CsCallerSumDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CsCallerDaoImpl
extends BaseDaoImpl
implements CsCallerDao {
    @Override
    public List<CsCallerDTO> getCsCallerDTO(CsCallerDTO csCallerDTO, Page page) {
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "SELECT cc.seqid,cc.accept,cc.answer,cc.demandId,cc.editBy,cc.editTime,cc.feedback,cc.lastCallTime,cc.orderNo, cc.phone,cc.userId,cc.status,ccd.demandName,ccd.backflow,ccd.beginTime,ccd.endTime,DATEDIFF(NOW(),cc.lastCallTime) AS days, ccd.gameId,ccd.inputBy,ccd.total,ccd.inputTime,ccd.remark,ccd.type,ccd.rule,'' as  fromBeginTime,'' as toBeginTime, ccdata.loginTime,ccdata.payTotal,'' as toSeqid, '' as fromSeqid \nfrom cs_caller cc\nLEFT JOIN cs_caller_demand ccd on cc.demandId = ccd.seqid \nLEFT JOIN cs_caller_data ccdata on ccdata.demandId = ccd.seqid and ccdata.userId = cc.userId \nwhere 1= 1 " + this.getCondition(csCallerDTO, list);
        if (page != null) {
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            sql = sql + " order by ccd.beginTime asc,ccd.seqid asc, cc.orderNo asc ";
            sql = sql + " limit " + (page.getPageNo() - 1) * page.getPageSize() + "," + page.getPageSize();
        }
        return this.findBySql(CsCallerDTO.class, sql, list);
    }

    @Override
    public int getCsCallerDTOCount(CsCallerDTO csCallerDTO) {
        ArrayList<Object> list = new ArrayList<Object>();
        String sql = "SELECT count(*) \nfrom cs_caller cc\nLEFT JOIN cs_caller_demand ccd on cc.demandId = ccd.seqid \nwhere 1= 1 " + this.getCondition(csCallerDTO, list);
        return this.getJdbcTemplate().queryForInt(sql, list.toArray());
    }

    private String getCondition(CsCallerDTO csCallerDTO, List<Object> param) {
        StringBuffer stringBuffer = new StringBuffer();
        if (csCallerDTO == null) {
            return stringBuffer.toString();
        }
        if (csCallerDTO.getSeqid() != null && csCallerDTO.getSeqid() > 0L) {
            stringBuffer.append(" and cc.seqid = ? ");
            param.add(csCallerDTO.getSeqid());
        }
        if (csCallerDTO.getDemandId() != null && csCallerDTO.getDemandId() > 0L) {
            stringBuffer.append(" and cc.demandId = ? ");
            param.add(csCallerDTO.getDemandId());
        }
        if (csCallerDTO.getUserId() != null && csCallerDTO.getUserId() > 0L) {
            stringBuffer.append(" and cc.userId = ? ");
            param.add(csCallerDTO.getUserId());
        }
        if (StringUtils.isNotEmpty((String)csCallerDTO.getGameId())) {
            stringBuffer.append(" and ccd.gameId = ? ");
            param.add(csCallerDTO.getGameId());
        }
        if (StringUtils.isNotEmpty((String)csCallerDTO.getDemandName())) {
            stringBuffer.append(" and ccd.demandName like ?");
            param.add("%" + csCallerDTO.getDemandName() + "%");
        }
        if (StringUtils.isNotEmpty((String)csCallerDTO.getFromBeginTime())) {
            stringBuffer.append(" and ccd.beginTime >= ? ");
            param.add(csCallerDTO.getFromBeginTime());
        }
        if (StringUtils.isNotEmpty((String)csCallerDTO.getToBeginTime())) {
            stringBuffer.append(" and ccd.beginTime <= ? ");
            param.add(csCallerDTO.getToBeginTime());
        }
        if (StringUtils.isNotEmpty((String)csCallerDTO.getPhone())) {
            stringBuffer.append(" and cc.phone = ? ");
            param.add(csCallerDTO.getPhone());
        }
        if (csCallerDTO.getAnswer() != null && csCallerDTO.getAnswer() > -1) {
            stringBuffer.append(" and cc.answer = ? ");
            param.add(csCallerDTO.getAnswer());
        }
        if (csCallerDTO.getAccept() != null && csCallerDTO.getAccept() > -1) {
            stringBuffer.append(" and cc.accept = ? ");
            param.add(csCallerDTO.getAccept());
        }
        if (csCallerDTO.getStatus() != null && csCallerDTO.getStatus() > -1) {
            stringBuffer.append(" and cc.status = ? ");
            param.add(csCallerDTO.getStatus());
        }
        if (csCallerDTO.getFromSeqid() != null && csCallerDTO.getFromSeqid().intValue() > 0) {
            stringBuffer.append(" and cc.orderNo >= ? ");
            param.add(csCallerDTO.getFromSeqid());
        }
        if (csCallerDTO.getToSeqid() != null && csCallerDTO.getToSeqid().intValue() > 0) {
            stringBuffer.append(" and cc.orderNo <= ? ");
            param.add(csCallerDTO.getToSeqid());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getLastCallTime(Long userId) {
        String sql = "select max(editTime) as lastCallTime from cs_caller where userId = ? ";
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(userId);
        Map forMap = this.findForMap(sql, list);
        return String.valueOf(forMap.get("lastCallTime"));
    }

    @Override
    public List<CsCallerSumDTO> getCsCallerSumDTO(CsCallerSumDTO csCallerSumDTO, Page page) {
        List sumDTOs;
        ArrayList<Object> param = new ArrayList<Object>();
        String sql = "select ccd.beginTime , ccd.endTime,ccd.demandName,ccd.seqid as demandid,c1.answerCount,c2.touchCount,c3.acceptCount,c4.paySum,c5.loginCount,\n0.0 as answerPrecent , 0.0 as acceptPrecent , 0.0 as successPrecent ,ccd.gameId,ccd.rule,ccd.backflow,ccd.total,ccd.remark,'' as fromBeginTime , '' as toBeginTime , ccd.type,ccd.inputTime,ccd.inputBy \nfrom cs_caller_demand  ccd \nLEFT JOIN (SELECT demandid,count(*) as answerCount from cs_caller WHERE answer =1 and status = 2 ) c1 on c1.demandid = ccd.seqid\nLEFT JOIN (SELECT demandid,count(*) as touchCount from cs_caller WHERE status = 2 and status = 2 ) c2 on c2.demandid = ccd.seqid\nLEFT JOIN (SELECT demandid,count(*) as acceptCount from cs_caller WHERE accept =1 and status = 2) c3 on c3.demandid = ccd.seqid\nLEFT JOIN (SELECT incc.demandid,sum(paytotal) as paySum from cs_caller_data inccd  LEFT JOIN cs_caller incc on inccd.demandId = incc.demandId and inccd.userId = incc.userId WHERE incc.status=2 and paytotal > 0  ) c4 on c4.demandid = ccd.seqid\nLEFT JOIN (SELECT incc.demandid,count(*) as loginCount from cs_caller_data inccd  LEFT JOIN cs_caller incc on inccd.demandId = incc.demandId and inccd.userId = incc.userId WHERE incc.status=2 and loginTime > 0) c5 on c5.demandid = ccd.seqid\nwhere 1 = 1 " + this.getCsCallerSumCondition(csCallerSumDTO, param);
        if (page != null) {
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            sql = sql + " order by ccd.beginTime desc ";
            sql = sql + " limit " + (page.getPageNo() - 1) * page.getPageSize() + "," + page.getPageSize();
        }
        if (CollectionUtils.isEmpty((Collection)(sumDTOs = this.findBySql(CsCallerSumDTO.class, sql, param)))) {
            return sumDTOs;
        }
        for (CsCallerSumDTO dto : sumDTOs) {
            if (dto.getTouchCount() == 0) {
                dto.setAnswerPrecent(0.0);
                dto.setAcceptPrecent(0.0);
                dto.setSuccessPrecent(0.0);
                continue;
            }
            BigDecimal answerCount = new BigDecimal(dto.getAnswerCount() == null ? 0 : dto.getAnswerCount());
            BigDecimal touchCount = new BigDecimal(dto.getTouchCount() == null ? 0 : dto.getTouchCount());
            BigDecimal acceptCount = new BigDecimal(dto.getAcceptCount() == null ? 0 : dto.getAcceptCount());
            BigDecimal loginCount = new BigDecimal(dto.getLoginCount() == null ? 0 : dto.getLoginCount());
            dto.setAnswerPrecent(answerCount.multiply(new BigDecimal(100)).divide(touchCount, 2, 4).doubleValue());
            dto.setAcceptPrecent(acceptCount.multiply(new BigDecimal(100)).divide(touchCount, 2, 4).doubleValue());
            dto.setSuccessPrecent(loginCount.multiply(new BigDecimal(100)).divide(answerCount, 2, 4).doubleValue());
        }
        return sumDTOs;
    }

    private String getCsCallerSumCondition(CsCallerSumDTO callerSumDTO, List<Object> param) {
        if (callerSumDTO == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (callerSumDTO.getDemandId() != null && callerSumDTO.getDemandId() > 0L) {
            buffer.append(" and ccd.seqid = ? ");
            param.add(callerSumDTO.getDemandId());
        }
        if (StringUtils.isNotEmpty((String)callerSumDTO.getGameId())) {
            buffer.append(" and ccd.gameId = ? ");
            param.add(callerSumDTO.getGameId());
        }
        if (StringUtils.isNotEmpty((String)callerSumDTO.getFromBeginTime())) {
            buffer.append(" and ccd.beginTime >= ? ");
            param.add(callerSumDTO.getFromBeginTime());
        }
        if (StringUtils.isNotEmpty((String)callerSumDTO.getToBeginTime())) {
            buffer.append(" and ccd.beginTime <= ? ");
            param.add(callerSumDTO.getToBeginTime());
        }
        if (StringUtils.isNotEmpty((String)callerSumDTO.getDemandName())) {
            buffer.append(" and ccd.demandName like ? ");
            param.add("%" + callerSumDTO.getDemandName() + "%");
        }
        return buffer.toString();
    }

    @Override
    public int getCsCallerSumDTOCount(CsCallerSumDTO csCallerSumDTO) {
        ArrayList<Object> param = new ArrayList<Object>();
        String sql = "select count(*) from cs_caller_demand ccd  where 1=1 " + this.getCsCallerSumCondition(csCallerSumDTO, param);
        return this.getJdbcTemplate().queryForInt(sql, param.toArray());
    }

    @Override
    public void deleteCsCallDemandBatch(Long ... seqids) {
        String seqIdStr = StringUtils.join((Object[])seqids, (String)",");
        String ccsql = "delete from cs_caller where demandId in  ( " + seqIdStr + " )";
        this.getJdbcTemplate().execute(ccsql);
        String ccdsql = "delete from cs_caller_demand where seqId in (" + seqIdStr + ")";
        this.getJdbcTemplate().execute(ccdsql);
    }

    @Override
    public void updateLastCallTimeByUid(Long uid, String time) {
        String sql = "update cs_caller set  lastCallTime = '" + time + "' where userid = " + uid + " and status = 0  ";
        this.getJdbcTemplate().update(sql);
    }
}

