/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.NewLoginAccountDao;
import com.xunlei.niux.data.vipgame.dto.game.GameLoginCountDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import java.util.LinkedList;
import java.util.List;

public class NewLoginAccountDaoImpl
extends BaseDaoImpl
implements NewLoginAccountDao {
    @Override
    public int getNewLoginAccountCount(int fromDate, int toDate, String gameId) {
        String sql = "select sum(login_account_new) from busi_login_account_new where fdate >= ? and fdate <= ? and gameid = ?";
        return this.getJdbcTemplate().queryForInt(sql, new Object[]{fromDate, toDate, gameId});
    }

    @Override
    public List<GameLoginCountDTO> getTopTotalLoginGames(int fromDate, int toDate, int size) {
        String sql = "select w.gameid as gameId, (w.login_account_w + n.new_count) as count from busi_login_account_w w inner join (select gameid, sum(login_account_new) as new_count from busi_login_account_new where fdate >= ? and fdate <= ? group by gameid) n on w.gameid = n.gameid order by count desc limit ?";
        LinkedList<Integer> params = new LinkedList<Integer>();
        params.add(fromDate);
        params.add(toDate);
        params.add(size);
        return this.executeQuery(GameLoginCountDTO.class, sql, params);
    }

    @Override
    public List<String> getTopGames(int date, int size) {
        String sql = "select t.gameid from (select gameid, sum(login_account_new) as count from busi_login_account_new where fdate = ? group by gameid) t order by t.count desc";
        LinkedList<Integer> params = new LinkedList<Integer>();
        params.add(date);
        if (size > 0) {
            sql = sql + " limit ?";
            params.add(size);
        }
        return this.getJdbcTemplate().queryForList(sql, params.toArray(), String.class);
    }

    @Override
    public List<Games> getTopGamesWithSameFeature(int fromDate, int toDate, int feature, int size) {
        String sql = "select g.* from(select w.gameid, (w.login_account_w + n.new_count) as total_count from busi_login_account_w w inner join (select gameid, sum(login_account_new) as new_count from busi_login_account_new where fdate >= ? and fdate <= ? group by gameid) n on w.gameid = n.gameid) t inner join games g on g.gameId = t.gameid where g.gameFeature = ? order by t.total_count desc limit ?";
        LinkedList<Integer> params = new LinkedList<Integer>();
        params.add(fromDate);
        params.add(toDate);
        params.add(feature);
        params.add(size);
        return this.executeQuery(Games.class, sql, params);
    }
}

