package com.xunlei.niux.data.vipgame.dto.game;

import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by lizeyu on 2015-09-24
 * 传给快玩游戏的基础数据
 */

public class KuaiWanGameDTO {
    private String gameId;
    private String gameNo;
    private String gameName;
    private String gameDesc;
    private Integer gameFeature;
    private String officialWebSite;
    private String picUrl;
    private String smallPicUrl;
    private Integer displayOrder;
    private Integer mobileGameType;
    private String summary;
    private String packageName;

    //扩展字段
    private String appSize;
    private String downLoadUrl;
    private Integer downloadNum;
    private String mulPhotoUrl;
    private String editTime;
    private String pic1;
    private String pic2;
    private String pic3;
    private String pic4;
    private String pic5;

    public Integer getDownloadNum() {
        return downloadNum;
    }

    public void setDownloadNum(Integer downloadNum) {
        this.downloadNum = downloadNum;
    }

    public String getDownLoadUrl() {
        return downLoadUrl;
    }

    public void setDownLoadUrl(String downLoadUrl) {
        this.downLoadUrl = downLoadUrl;
    }

    public String getGameDesc() {
        return gameDesc;
    }

    public void setGameDesc(String gameDesc) {
        this.gameDesc = gameDesc;
    }

    public String getGameId() {
        return gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public String getGameName() {
        return gameName;
    }

    public void setGameName(String gameName) {
        this.gameName = gameName;
    }

    public String getGameNo() {
        return gameNo;
    }

    public void setGameNo(String gameNo) {
        this.gameNo = gameNo;
    }

    public String getMulPhotoUrl() {
        return mulPhotoUrl;
    }

    public void setMulPhotoUrl(String mulPhotoUrl) {
        this.mulPhotoUrl = mulPhotoUrl;
    }

    public String getOfficialWebSite() {
        return officialWebSite;
    }

    public void setOfficialWebSite(String officialWebSite) {
        this.officialWebSite = officialWebSite;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getSmallPicUrl() {
        return smallPicUrl;
    }

    public void setSmallPicUrl(String smallPicUrl) {
        this.smallPicUrl = smallPicUrl;
    }

    public String getAppSize() {
        return appSize;
    }

    public void setAppSize(String appSize) {
        this.appSize = appSize;
    }

    public Integer getGameFeature() {
        return gameFeature;
    }

    public void setGameFeature(Integer gameFeature) {
        this.gameFeature = gameFeature;
    }

    public Integer getDisplayOrder() {
        return displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public Integer getMobileGameType() {
        return mobileGameType;
    }

    public void setMobileGameType(Integer mobileGameType) {
        this.mobileGameType = mobileGameType;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getEditTime() {
        return editTime;
    }

    public void setEditTime(String editTime) {
        this.editTime = editTime;
    }

    public String getPic1() {
        return pic1;
    }

    public void setPic1(String pic1) {
        this.pic1 = pic1;
    }

    public String getPic2() {
        return pic2;
    }

    public void setPic2(String pic2) {
        this.pic2 = pic2;
    }

    public String getPic3() {
        return pic3;
    }

    public void setPic3(String pic3) {
        this.pic3 = pic3;
    }

    public String getPic4() {
        return pic4;
    }

    public void setPic4(String pic4) {
        this.pic4 = pic4;
    }

    public String getPic5() {
        return pic5;
    }

    public void setPic5(String pic5) {
        this.pic5 = pic5;
    }

    public Map<String,Object> generateAppGameMap(Map<String, LinkInfo> mobileGameDownloadInfoMap){
        Map<String, Object> map = new HashMap<String, Object>();
        String gameId = getGameId();

        map.put("gameId",gameId);
        map.put("gameNo",getGameNo());
        map.put("img", getPicUrl() == null ? "" : getPicUrl());
        map.put("icon", getSmallPicUrl() == null ? "" : getSmallPicUrl());
        map.put("gameName", getGameName());
        map.put("gameDesc", getGameDesc() == null ? "" : getGameDesc());
        map.put("gameFeature",getGameFeature());
        map.put("featureId",getGameFeature());
        map.put("typeId","");
        map.put("gameOfficialLink", getOfficialWebSite() == null ? "" : getOfficialWebSite());

        map.put("downloadLink", getDownLoadUrl()==null?"":getDownLoadUrl());
        map.put("displayOrder",getDisplayOrder());
        map.put("mulPhotoUrl",getMulPhotoUrl());

        if(gameId.startsWith("c")){
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(getDownloadNum())));
            map.put("fileSize",getAppSize());
        }else {
            LinkInfo gameDownloadInfo = mobileGameDownloadInfoMap.get(getGameId());
            if (gameDownloadInfo == null) {
                map.put("downloadNum", "");
                map.put("fileSize","");
            } else {
                map.put("downloadNum", NumParseUtil.getDownloadNumStr(gameDownloadInfo.getExt1()));
                map.put("fileSize",gameDownloadInfo.getExt2());
            }
        }
        return map;
    }
}
