package com.xunlei.niux.data.vipgame.dao;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.annotation.Exclude;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.SubGameXmlMeta;

public class GameXmlMetaDaoImpl extends BaseDaoImpl implements GameXmlMetaDao {

	private static final String _SUB_FIELD = "clientType";
	
	@Override
	public int countSubGameXmlMeta(Integer type, Integer isOnline, GameXmlMeta cc) {
		List<Object> args = new ArrayList();
		String subSql = "SELECT count(0) FROM gamexmlmeta gxm LEFT JOIN games gms ON gms.gameId = gxm.newgameid ";
		String countSql = createSql(type, isOnline, cc, args, subSql);
		return getJdbcTemplate().queryForInt(countSql, args.toArray());
	}

	@Override
	public List<SubGameXmlMeta> querySubGameXmlMeta(Integer type, Integer isOnline, GameXmlMeta cc, Page page) {
		List<Object> args = new ArrayList();
		String subSql = "SELECT gms.clientType, gxm.* FROM gamexmlmeta gxm LEFT JOIN games gms ON gms.gameId = gxm.newgameid ";
		String querySql = createSql(type, isOnline, cc, args, subSql) + createOrder(page) + createLimit(page);
		final List<SubGameXmlMeta> metas = new ArrayList<SubGameXmlMeta>();
		getJdbcTemplate().query(querySql, args.toArray(), new RowCallbackHandler() {
			@Override
			public void processRow(ResultSet rSet) throws SQLException {
				metas.add(handleGameXmlMeta(rSet));
			}
		});
		return metas;
	}
	
	private SubGameXmlMeta handleGameXmlMeta(ResultSet rSet) {
		SubGameXmlMeta subMeta = new SubGameXmlMeta();
		try {
			Field[] fields = GameXmlMeta.class.getDeclaredFields();
			for(Field field : fields) {
				if(field.getAnnotation(Exclude.class) != null) continue;
				String name = DaoUtil.getColumnName(field);
				Object value = DaoUtil.getColumnValue(rSet, field.getType(), name);
				DaoUtil.setFiledValue(subMeta, field, value);
			}
			subMeta.setClientType(rSet.getInt(_SUB_FIELD));
		} catch(Exception ex){ }
		return subMeta;
	}
	
	private String createSql(Integer type, Integer isOnline, GameXmlMeta cc, List<Object> args, String subSql) {
		StringBuffer whereSubfix = new StringBuffer();
		String where = DaoUtil.createWhere(cc, args);
		if(type < 9) whereSubfix.append(" and gms.clientType = ").append(type);
		if(isOnline == 1) whereSubfix.append(" and length(gxm.onlineurl) > 0");
		if(isOnline == 2) whereSubfix.append(" and ifnull(length(gxm.onlineurl), 0) < 1");
		if(!where.contains(" where ") && whereSubfix.length() > 0) {
			return subSql + " where " + whereSubfix.toString().substring(4);
		}
		return subSql + where + whereSubfix;
	}

	private String createLimit(Page page) {
		if (!page.isPage()) {
			return "";
		}
		int start = (page.getPageNo() - 1) * page.getPageSize();
		return " limit " + start + "," + page.getPageSize();
	}

	private String createOrder(Page page) {
		if (!page.isOrder()) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		List<Order> list = page.getOrderList();
		for (Order order : list) {
			Field field = DaoUtil.getDeclaredField(GameXmlMeta.class, order.getOrderName());
			String columnName = DaoUtil.getColumnName(field);
			sb.append(",").append(columnName);
			if (order.getType() == OrderType.DESC) {
				sb.append(" desc");
			} else {
				sb.append(" asc");
			}
		}
		String orderStr = sb.toString();
		if (orderStr.startsWith(",")) {
			orderStr = orderStr.substring(1);
		}
		if (orderStr.length() > 0) {
			orderStr = " order by " + orderStr;
		}
		return orderStr;
	}
}