package com.xunlei.niux.data.vipgame.dao.gift;

import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductChargeRecord;

import java.util.List;
import java.util.Set;

/**
 * Created by jamesjxin on 14-4-17.
 */
public interface GiftRecordDao {

    public List<GiftRecordDTO> getUnReleaseProductGiftRecord();
    
    public List<ProductDTO> getBonusProductChargeList(int max);

    public List<ProductDTO> getTimeLimitBonusProductChargeList(int max);

    List<?> getJiFenShopGiftRecord(Class<?> object, String userId,  Set<String> giftTypeParamSet, int pageNo, int pageSize);

    List<?> getUserGiftRecordByGiftType(Class<?> object, String userId,  Set<String> giftTypeParamSet, int pageNo, int pageSize);

    int countUserGiftRecordByGiftType(String userId, Set<String> giftTypeParamSet);

    int countJiFenShopGiftRecord( String userId,  Set<String> giftTypeParamSet);

    List<ActivityNGiftNGiftRecordDTO> getUserGiftRecordsByActNo(String userId, String actNo);
    
    int countGiftRecordInOneDay(String userId, String date);

    int countGiftRecord(String userId, String startTime, String endTime);

    int countGiftRecord(String userId, String giftType, String startTime, String endTime);

    List<ProductDTO> getBonusProductChargeList(final int listNum, final boolean isTimeLimit, final boolean isEntityGift);

    //增加对盒子的判断
    List<ProductDTO> getBonusProductChargeList(final int listNum, final boolean isTimeLimit, final boolean isEntityGift,final boolean isBox);
    
    List<ProductDTO> getBoxBonusProductChargeList(final int listNum, final boolean isTimeLimit, final boolean isEntityGift);
    
    //获取相对于当天相差addDays天的兑换商品
    List<ProductDTO> getDayBoxProduct(boolean isTimeLimit, boolean isEntityGift, int listNum,int giftId);

    //按天获取用户领奖记录
    int getBonusProductChargeRecordByDay(String userId, String giftId, String day);
    //按天获取所有用户领奖记录
    List<BonusProductChargeRecord> getBonusProductChargeRecordByDay( String day);
}
