package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.customer.CustomerPhone;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangya on 2016/11/10.
 */
public class CustomerPhoneDaoImpl extends BaseDaoImpl implements CustomerPhoneDao  {

    @Override
    public void addNewPhoneAndUpdateLevel(CustomerPhone phone) {
        String sql = "select * from customerphone where uid = ? and phone = ? for update";

        List<Object> param = new ArrayList<Object>(2);
        param.add(phone.getUid());
        param.add(phone.getPhone());

        List<CustomerPhone> phones = findBySql(CustomerPhone.class, sql, param);

        int level = 1 ;
        if(CollectionUtils.isNotEmpty(phones)){
            level += phones.size();
            for(CustomerPhone cphone :phones){
                if(phone.getAdvNo().trim().equals(cphone.getAdvNo().trim())){
                    deleteById(CustomerPhone.class,cphone.getSeqid());
                    level--;
                }
            }

            insert(phone);

            if(level == 1)
                return;

            String updateSql = " update customerphone set level = ?,status = ? ,editBy= ? where uid= ? and phone = ? ";
            List<Object> updateParam = new ArrayList<Object>(3);
            updateParam.add(level);
            updateParam.add(1);
            updateParam.add("system");
            updateParam.add(phone.getUid());
            updateParam.add(phone.getPhone());
            execute(updateSql,updateParam);
        }else {
            insert(phone);
        }

    }




}
