package com.xunlei.niux.data.vipgame.bo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.Question;

public class QuestionBoImpl extends BaseDaoImpl implements QuestionBo {

    private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public int count(Question question) {
		return baseDao.count(question);
	}

	public void execute(String presql, final List paramList){
		baseDao.execute(presql, paramList);
	}
	@Override
	public void deleteById(long id) {
		baseDao.deleteById(Question.class, id);
	}
	
	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}

	@Override
	public List<Question> find(Question question, int pageNo,
			int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("committime", OrderType.DESC);
		return baseDao.findByObject(Question.class, question, page);
	}
	 
	public List<Question> findBySql(Question question,String preSql, int pageNo,
			int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("committime", OrderType.DESC);
		return findByObject(Question.class, question, page,preSql);
	}
	 public List findByObject(Class clazz, Object obj, Page page,String preSql){
	        List paramsList = new ArrayList();
	        String tableName = DaoUtil.getTableName(obj.getClass());
	        String where = DaoUtil.createWhere(obj, paramsList);
	        where += " and 1=1 ";
	        String order = createOrder(obj, page);
	        String limit = createLimit(page);
	        String sql = (new StringBuilder("select * from ")).append(tableName).append(where).append(order).append(limit).toString();
	        return executeQuery(clazz, preSql, paramsList);
	    }
	 
	 public String createLimit(Page page)
	    {
	        if(!page.isPage())
	        {
	            return "";
	        } else
	        {
	            int start = (page.getPageNo() - 1) * page.getPageSize();
	            return (new StringBuilder(" limit ")).append(start).append(",").append(page.getPageSize()).toString();
	        }
	    }
	 
	 public String createOrder(Object obj, Page page)
	    {
	        if(!page.isOrder())
	            return "";
	        StringBuilder sb = new StringBuilder();
	        List list = page.getOrderList();
	        for(Iterator iterator = list.iterator(); iterator.hasNext();)
	        {
	            Order order = (Order)iterator.next();
	            Field field = DaoUtil.getDeclaredField(obj.getClass(), order.getOrderName());
	            String columnName = DaoUtil.getColumnName(field);
	            sb.append(",").append(columnName);
	            if(order.getType() == OrderType.DESC)
	                sb.append(" desc");
	            else
	                sb.append(" asc");
	        }

	        String orderStr = sb.toString();
	        if(orderStr.startsWith(","))
	            orderStr = orderStr.substring(1);
	        if(orderStr.length() > 0)
	            orderStr = (new StringBuilder(" order by ")).append(orderStr).toString();
	        return orderStr;
	    }

	@Override
	public Question findById(long id) {
		return baseDao.findById(Question.class, id);
	}

	@Override
	public void insert(Question question) {
		 baseDao.insert(question);
	}

	@Override
	public void update(Question question) {
		baseDao.updateById(question);
	}
	public  List findBySql(Class clazz, String preSql, List paramList) {
		return baseDao.findBySql(clazz, preSql, paramList);
	}

}
