package com.xunlei.niux.data.vipgame.dao;

import java.util.LinkedList;
import java.util.List;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.Games;


public class NewLoginAccountDaoImpl extends BaseDaoImpl implements NewLoginAccountDao {

	@Override
	public int getNewLoginAccountCount(int fromDate, int toDate, String gameId) {
		String sql = "select sum(login_account_new) from busi_login_account_new where fdate >= ? and fdate <= ? and gameid = ?";
		return getJdbcTemplate().queryForInt(sql, new Object[] { fromDate, toDate, gameId });
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<String> getTopTotalLoginGames(int fromDate, int toDate, int size) {
		String sql = "select t.gameid from(select w.gameid, (w.login_account_w + n.new_count) as total_count "
				+ "from busi_login_account_w w inner join (select gameid, sum(login_account_new) as new_count "
				+ "from busi_login_account_new where fdate >= ? and fdate <= ? group by gameid) n "
				+ "on w.gameid = n.gameid order by total_count desc limit ?) t";
		
		return getJdbcTemplate().queryForList(sql, new Object[] { fromDate, toDate, size }, String.class);
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<String> getTopGames(int date, int size) {
		String sql = "select t.gameid from (select gameid, sum(login_account_new) as count "
				+ "from busi_login_account_new where fdate = ? group by gameid) t order by t.count desc";
		
		List<Object> params = new LinkedList<Object>();
		params.add(date);
		
		if(size > 0) {
			sql += " limit ?";
			params.add(size);
		}
		
		return getJdbcTemplate().queryForList(sql, params.toArray(), String.class);
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<Games> getTopGamesWithSameFeature(int fromDate, int toDate, int feature, int size) {
		String sql = "select g.* from(select w.gameid, (w.login_account_w + n.new_count) as total_count"
				+ "from busi_login_account_w w inner join (select gameid, sum(login_account_new) as new_count"
				+ "from busi_login_account_new where fdate >= ? and fdate <= ? group by gameid) n"
				+ "on w.gameid = n.gameid) t inner join games g on g.gameId = t.gameid where g.gameFeature = ?"
				+ "order by t.total_count desc limit ?";
		
		return getJdbcTemplate().queryForList(sql, new Object[] { fromDate, toDate, feature, size }, Games.class);
	}
}
