package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;

import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.vo.FortuneInfo;
import com.xunlei.niux.data.vipgame.vo.FortuneRecord;
@Service
public class FortuneBoImpl extends CommonSo implements FortuneBo {
	public void addFortuneRecord(FortuneRecord p_fortuneRecord){
		if(p_fortuneRecord.getFortunePoint()<0){
			throw new RuntimeException("非法人品点数");
		}
		//判断是否重复
		FortuneRecord oldFortuneRecord=queryFortuneRecord(p_fortuneRecord.getActNo(), p_fortuneRecord.getThirdOrderNo());
		if(oldFortuneRecord!=null){
			throw new RuntimeException("活动编号["+p_fortuneRecord.getActNo()+"]第三方订单["+p_fortuneRecord.getThirdOrderNo()+"]的人品记录已经存在");
		}
		FortuneInfo fortuneInfo=queryLockFortuneInfoIfNoExistSetDefault(p_fortuneRecord.getUserId());
		Date curDate=new Date();
		if("ADD".equals(p_fortuneRecord.getRecordType())){
			fortuneInfo.setFortunePoint(fortuneInfo.getFortunePoint()+p_fortuneRecord.getFortunePoint());
			fortuneInfo.setFortunePointSum(fortuneInfo.getFortunePointSum()+p_fortuneRecord.getFortunePoint());
		}else{
			fortuneInfo.setFortunePoint(fortuneInfo.getFortunePoint()-p_fortuneRecord.getFortunePoint());
		}
		if(fortuneInfo.getFortunePoint()<0){
			throw new RuntimeException("userId["+p_fortuneRecord.getUserId()+"]人品点数不够");
		}
		baseDao.updateById(fortuneInfo);
		p_fortuneRecord.setRecordTime(sdfTime.format(curDate));
		baseDao.insert(p_fortuneRecord);
	}
	private FortuneRecord queryFortuneRecord(String actNo,String thirdOrderNo){
		if(StringTools.isEmpty(actNo)||StringTools.isEmpty(thirdOrderNo)){
			throw new RuntimeException("活动编号和第三方订单号查询人品记录参数为空");
		}
		FortuneRecord queryRecord=new FortuneRecord();
		queryRecord.setActNo(actNo);
		queryRecord.setThirdOrderNo(thirdOrderNo);
		return super.findObject(queryRecord);
	}
	private FortuneInfo queryLockFortuneInfoIfNoExistSetDefault(String userId){
		FortuneInfo forturneInfo=queryLockFortuneInfo(userId);
		if(forturneInfo==null){
			forturneInfo=new FortuneInfo();
			forturneInfo.setExt1("");
			forturneInfo.setFortunePoint(0L);
			forturneInfo.setFortunePointSum(0L);
			forturneInfo.setUserId(userId);
			Date nowDate=new Date();
			forturneInfo.setLastUpdateTime(sdfTime.format(nowDate));
			baseDao.insert(forturneInfo);
			forturneInfo=queryLockFortuneInfo(userId);
		}
		return forturneInfo;
	}
	private FortuneInfo queryLockFortuneInfo(String userId){
		if(StringTools.isEmpty(userId)){
			throw new RuntimeException("查询人品信息的userId参数为空");
		}
		String sql="select * from fortuneinfo where userId=?";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(userId);
		List<FortuneInfo> fortuneList=baseDao.executeQuery(FortuneInfo.class, sql, paramList);
		return (fortuneList==null||fortuneList.size()==0)?null:fortuneList.get(0);
	}
}
