package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.dto.vic.*;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RebateReportBoImpl implements RebateReportBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String,RebateReportPersonDTO> queryRebateReportPersonByDate(String startDate, String endDate) {
        Map<String,RebateReportPersonDTO> map = new HashMap<String, RebateReportPersonDTO>();
        String sql1 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person," +
                " 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 7 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.inputBy  ";
        String sql2 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person," +
                " 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 3 and r.vipGrade <= 6 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.inputBy  ";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportPersonDTO> list1 = baseDao.findBySql(RebateReportPersonDTO.class,sql1,params);
        List<RebateReportPersonDTO> list2 = baseDao.findBySql(RebateReportPersonDTO.class,sql2,params);
        for(RebateReportPersonDTO dto:list1){//大R
            RebateReportPersonDTO data = new RebateReportPersonDTO();
            data.setPerson(dto.getPerson());
            data.setFinished(dto.getFinished());
            data.setFinishedRiChang(dto.getFinished());//大R
            data.setFinishedYeJi(0.0);
            data.setRebatemoney(dto.getRebatemoney());
            map.put(dto.getPerson(),data);
        }
        for(RebateReportPersonDTO dto:list2){//中R
            RebateReportPersonDTO data = map.get(dto.getPerson());
            if(data==null){
                data = new RebateReportPersonDTO();
                data.setPerson(dto.getPerson());
                data.setFinished(dto.getFinished());
                data.setFinishedRiChang(0.0);
                data.setFinishedYeJi(dto.getFinished());//中R
                data.setRebatemoney(dto.getRebatemoney());
            }else{
                data.setRebatemoney(data.getRebatemoney()+dto.getRebatemoney());
                data.setFinished(data.getFinished()+dto.getFinished());
                data.setFinishedYeJi(data.getFinishedYeJi() + dto.getFinished());//中R
            }
            map.put(data.getPerson(),data);
        }
        return map;
    }

    private String getSqlString(){
        return "SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person, \n" +
                " 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, \n" +
                " 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi ,0.0 as finishAll," +
                " 0.0 as finishActRc,0.0 as finishActYj,0.0 as finishAct, r.workType \n" +
                " FROM  (SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>= ? AND orderTime<= ? ) o  \n" +
                " INNER JOIN rebateapply r ON o.aporderid=r.aporderid  \n" +
                " WHERE  r.vipGrade >= ? and r.vipGrade <= ?   and r.checkstatus in (-1,0,1) and r.workType in (2,3)\n" +
                " GROUP BY r.inputBy,r.workType order by r.inputBy,r.workType ";
    }


    @Override
    public Map<String,RebateReportPersonNewDTO> queryNewRebateReportPersonByDate(String startDate, String endDate) {
        Map<String,RebateReportPersonNewDTO> map = new HashMap<String, RebateReportPersonNewDTO>();

        String sql = getSqlString();
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        params.add(7);
        params.add(100);

        List<Object> params2 = new ArrayList<Object>();
        params2.add(startDate);
        params2.add(endDate);
        params2.add(3);
        params2.add(6);
        List<RebateReportPersonNewDTO> list1 = baseDao.findBySql(RebateReportPersonNewDTO.class,sql,params);
        List<RebateReportPersonNewDTO> list2 = baseDao.findBySql(RebateReportPersonNewDTO.class,sql,params2);

        for(RebateReportPersonNewDTO dto:list1){//大R

            RebateReportPersonNewDTO data = map.get(dto.getPerson());
            if(data == null){
                data.setPerson(dto.getPerson());
                data.setFinishedYeJi(0.0);
                map.put(dto.getPerson(),data);
            }

            if(dto.getWorkType().intValue()==2){
                data.setFinishedRiChang( dto.getFinished());//大R
                data.setFinished(dto.getFinished());
            }else if(dto.getWorkType().intValue()==3){
                data.setFinishAct(dto.getFinished());
                data.setFinishActRc(dto.getFinished());
            }
            data.setRebatemoney((data.getRebatemoney()==null?0.0:data.getRebatemoney())+dto.getRebatemoney());
            data.setFinishAll((data.getFinishAll()==null?0.0:data.getFinishAll())+dto.getFinished());

        }


        for(RebateReportPersonNewDTO dto:list2){//中R
            RebateReportPersonNewDTO data = map.get(dto.getPerson());
            if(data==null){
                data = new RebateReportPersonNewDTO();
                data.setPerson(dto.getPerson());
                data.setFinishedRiChang(0.0);
                map.put(data.getPerson(),data);
            }

            if(dto.getWorkType().intValue()==2){
                data.setFinishedYeJi( dto.getFinished());//中R
                data.setFinished((data.getFinished()==null?0.0:data.getFinished())+dto.getFinished());
            }else if(dto.getWorkType().intValue()==3){
                data.setFinishAct((data.getFinishActRc()==null?0.0:data.getFinishActRc())+dto.getFinished());
                data.setFinishActYj(dto.getFinished());
            }

            data.setFinishAll((data.getFinishAll()==null?0.0:data.getFinishAll())+dto.getFinished());
            data.setRebatemoney((data.getRebatemoney()==null?0.0:data.getRebatemoney())+dto.getRebatemoney());
        }
        return map;
    }

    /**
     * 查询VIP等级大于等于3（中R以上）的
     */
    @Override
    public RebateReportTeamDTO queryRebateReportByDate(String startDate, String endDate) {
        String sql = " SELECT SUM(r.money) AS finished,r.workType, 0.0 as finishedRiChang, 0.0 as finishedYeJi, r.vipGrade," +
                " 0.0 as finishActRc, 0.0 as finishActYj,0.0 as finishAct ,0.0 as finishAll,0.0 as finishRc,0.0 as finishYj FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE r.vipGrade >= 3 and r.checkstatus in (-1,0,1)  and r.workType in (2,3)  GROUP BY r.vipGrade,r.workType";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportTeamDTO> list = baseDao.findBySql(RebateReportTeamDTO.class,sql, params);
        RebateReportTeamDTO dto = new RebateReportTeamDTO();
        for(RebateReportTeamDTO teamKpi : list){

            if(teamKpi.getWorkType().intValue() ==2){

                dto.setFinished((dto.getFinished() == null ? 0.0: dto.getFinished()) + teamKpi.getFinished());
                if(teamKpi.getVipGrade() >= 7){//大R VipGrade>=7
                    dto.setFinishedRiChang((dto.getFinishedRiChang() == null ? 0.0 : dto.getFinishedRiChang()) + teamKpi.getFinished());
                    dto.setFinishRc((dto.getFinishRc() == null ? 0.0 : dto.getFinishRc())+ teamKpi.getFinished());
                }else{//中R  6>=VipGrade>=3
                    dto.setFinishedYeJi((dto.getFinishedYeJi() == null ? 0.0 : dto.getFinishedYeJi()) + teamKpi.getFinished());
                    dto.setFinishYj((dto.getFinishYj() == null ? 0.0 : dto.getFinishYj()) + teamKpi.getFinished());
                }

            }else if(teamKpi.getWorkType().intValue()==3){

                dto.setFinishAct((dto.getFinishAct() == null ? 0.0: dto.getFinishAct()) + teamKpi.getFinished());
                if(teamKpi.getVipGrade() >= 7){//大R VipGrade>=7
                    dto.setFinishActRc((dto.getFinishActRc() == null ? 0.0 : dto.getFinishActRc()) + teamKpi.getFinished());
                    dto.setFinishRc((dto.getFinishRc() == null ? 0.0 : dto.getFinishRc())+ teamKpi.getFinished());
                }else{//中R  6>=VipGrade>=3
                    dto.setFinishActYj((dto.getFinishActYj() == null ? 0.0 : dto.getFinishActYj()) + teamKpi.getFinished());
                    dto.setFinishYj((dto.getFinishYj() == null ? 0.0 : dto.getFinishYj()) + teamKpi.getFinished());
                }
            }

            dto.setFinishAll(dto.getFinishAll() == null ? teamKpi.getFinished() : dto.getFinishAll() + teamKpi.getFinished());

        }
        return dto;
    }




    @Override
    public Map<String,Double> queryRebateReportGameByDate(String startDate, String endDate) {
        Map<String,Double> map = new HashMap<String, Double>();
        String sql = " SELECT SUM(r.money) AS finished, r.gameid, 0 AS kpisale, 0.0 AS salerate,0 AS kpiincome, 0.0 AS income,0.0 AS incomerate,0.0 AS saleincomerate  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 3 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.gameid ";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportGameDTO> list = baseDao.findBySql(RebateReportGameDTO.class,sql,params);
        for(RebateReportGameDTO dto:list){
            map.put(dto.getGameid(),dto.getFinished());
        }
        return map;
    }

    @Override
    public List<RebateReportOldGameDTO> queryOldGameKpiSumForPerson(String kpiDate) {
        String sql = " SELECT person, SUM(kpi) AS kpitotal, 0.0 AS finished, 0.0 AS kpirate FROM vic_rebate_report_old_game_config WHERE kpiDate=? GROUP BY person ";
        List<Object> params = new ArrayList<Object>();
        params.add(kpiDate);
        return baseDao.findBySql(RebateReportOldGameDTO.class,sql,params);
    }

}
