/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.bonus;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.bo.bonus.SignDayNumBo;
import com.xunlei.niux.data.vipgame.bo.bonus.SignRecordBo;
import com.xunlei.niux.data.vipgame.vo.bonus.SignDayNum;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SignRecordBoImpl
implements SignRecordBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdfshort = new SimpleDateFormat("yyyy-MM-dd");
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Resource
    private SignDayNumBo signDayNumBo;

    public SignDayNumBo getSignDayNumBo() {
        return this.signDayNumBo;
    }

    public void setSignDayNumBo(SignDayNumBo signDayNumBo) {
        this.signDayNumBo = signDayNumBo;
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<SignRecord> find(SignRecord signRecord, Page page) {
        return this.baseDao.findByObject(SignRecord.class, (Object)signRecord, page);
    }

    @Override
    public int count(SignRecord signRecord) {
        return this.baseDao.count((Object)signRecord);
    }

    @Override
    public void update(SignRecord signRecord) {
        this.baseDao.updateById((Object)signRecord);
    }

    @Override
    public SignRecord find(String userId, Long seqId) {
        SignRecord signRecord = new SignRecord();
        signRecord.setUserId(userId);
        signRecord.setSeqId(seqId);
        List<SignRecord> list = this.find(signRecord, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public SignRecord find(String userId, String signDate) {
        SignRecord signRecord = new SignRecord();
        signRecord.setUserId(userId);
        signRecord.setSignDate(signDate);
        List<SignRecord> list = this.find(signRecord, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public SignRecord findLatestSign(String userId) {
        SignRecord signRecord = new SignRecord();
        signRecord.setUserId(userId);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("signDate", OrderType.DESC);
        List<SignRecord> list = this.find(signRecord, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public SignRecord insert(SignRecord signRecord, boolean isReSign) {
        Date now = new Date();
        SignRecord latestSignRecord = this.findLatestSign(signRecord.getUserId());
        if (isReSign) {
            signRecord.setSeriesSignDays(latestSignRecord.getSeriesSignDays());
        } else {
            signRecord.setSeriesSignDays(this.calSeriesSignDays(latestSignRecord, now));
        }
        signRecord.setSignNo(OrderNoUtil.getOrderNo());
        signRecord.setSignTime(sdf.format(now));
        if (StringTools.isEmpty((String)signRecord.getSignDate())) {
            signRecord.setSignDate(sdfshort.format(now));
        }
        signRecord.setNextGiveOutTime(sdf.format(now));
        signRecord.setSignSumDays(isReSign ? latestSignRecord.getSeriesSignDays().intValue() : this.calSignSumDays(latestSignRecord));
        signRecord.setBonusNum(isReSign ? 1 : this.calSignBonus(signRecord.getSeriesSignDays()));
        signRecord.setGiveOutBonusStatus("0");
        int todaySignIndex = this.updateSignDayNum(sdfshort.format(now), isReSign);
        signRecord.setTodaySignIndex(todaySignIndex);
        int signTotalBonusNum = this.calSignBonusTotalNum(latestSignRecord, signRecord.getBonusNum());
        signRecord.setSignTotalBonusNum(isReSign ? latestSignRecord.getSignTotalBonusNum() + 1 : signTotalBonusNum);
        this.baseDao.insert((Object)signRecord);
        return signRecord;
    }

    private int updateSignDayNum(String signDate, boolean isReSign) {
        SignDayNum signDayNum = this.signDayNumBo.findAndUpdateLock(signDate);
        if (isReSign) {
            return signDayNum.getTotalSignNum();
        }
        if (signDayNum == null) {
            signDayNum = new SignDayNum();
            signDayNum.setSignDate(signDate);
            signDayNum.setTotalSignNum(0);
        }
        signDayNum.setTotalSignNum(signDayNum.getTotalSignNum() + 1);
        if (signDayNum.getSeqId() == null) {
            this.signDayNumBo.insert(signDayNum);
        } else {
            this.signDayNumBo.update(signDayNum);
        }
        return signDayNum.getTotalSignNum();
    }

    private int calSignBonus(int seriesSignDays) {
        return 1;
    }

    private int calSignBonusTotalNum(SignRecord latestSignRecord, int bonusNum) {
        if (latestSignRecord == null) {
            return bonusNum;
        }
        return bonusNum + latestSignRecord.getSignTotalBonusNum();
    }

    private int calSeriesSignDays(SignRecord latestSignRecord, Date now) {
        String nowDate = sdfshort.format(now);
        Date yes = new Date(now.getTime() - 86400000L);
        if (latestSignRecord == null) {
            return 1;
        }
        if (nowDate.equals(latestSignRecord.getSignDate())) {
            throw new RuntimeException("\u4eca\u5929\u5df2\u7b7e\u5230");
        }
        if (latestSignRecord.getSignDate().equals(sdfshort.format(yes))) {
            return latestSignRecord.getSeriesSignDays() + 1;
        }
        return 1;
    }

    private int calSignSumDays(SignRecord latestSignRecord) {
        if (latestSignRecord == null) {
            return 1;
        }
        return latestSignRecord.getSignSumDays() + 1;
    }
}

