package com.xunlei.niux.data.vipgame.bo.version;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
@Service
public class GameVersionBoImpl implements GameVersionBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Override
	public List<GameVersion> find(GameVersion gameVersion, Page page) {
		if(gameVersion==null){
			return new ArrayList<GameVersion>();
		}
		return baseDao.findByObject(GameVersion.class, gameVersion, page);
	}

	@Override
	public int count(GameVersion gameVersion) {
		if(gameVersion==null){
			return 0;
		}
		return baseDao.count(gameVersion);
	}
	public GameVersion find(String gameId){
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		GameVersion gameVersion=new GameVersion();
		gameVersion.setGameId(gameId);
		List<GameVersion> list=find(gameVersion,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	@Override
	public void insert(GameVersion gameVersion) {
		baseDao.insert(gameVersion);
	}

	@Override
	public void update(GameVersion gameVersion) {
		baseDao.updateById(gameVersion);
	}

	@Override
	public void delete(GameVersion gameVersion) {
		baseDao.deleteById(GameVersion.class, gameVersion.getSeqId());
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
