package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.Income;

import java.util.List;

/**
 * @author hezhong
 */
public class IncomeBoImpl implements IncomeBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<Income> find(Income income, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("incomemonth", OrderType.ESC);

        return baseDao.findByObject(Income.class, income, page);

    }

    @Override
    public int count(Income income) {
        return baseDao.count(income);
    }

    @Override
    public Income findById(Integer seqid) {
        return baseDao.findById(Income.class, seqid);
    }

    @Override
    public void update(Income income) {
        baseDao.updateById(income);
    }

    @Override
    public List<Income> findSql(String sql) {
        return baseDao.findBySql(Income.class, sql);
    }

    @Override
    public void insert(Income income) {
        baseDao.insert(income);
    }

    @Override
    public void execute(String sql, List<Object> list) {
        baseDao.execute(sql, list);
    }


}
