package com.xunlei.niux.data.vipgame.vo.crystal;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import com.ferret.common.dao.annotation.Table;

/**
 * 理财套餐配置
 * 
 * @author HuangGuangHao
 */
@Table(tableName = "financialPackages", pkFieldName = "seqId", pkFieldAssign = false)
@JsonIgnoreProperties({"seqId", "status", "inputTime", "inputBy", "editTime", "editBy"})
public class FinancialPackages {
	private Long seqId;				// 主键
	private String packageName; 	// 套餐名称
	private Integer price; 			// 套餐价格
	private Integer crystal; 		// 水晶数量
	private Integer days; 			// 理财周期
	private Integer rebate; 		// 收益比例
	private Integer totalNum; 		// 套餐总数量
	private Integer leftNum; 		// 套餐剩余数量
	private Integer status; 		// 状态
	private String remark; 			// 注释
	private String inputTime; 		// 添加时间
	private String inputBy; 		// 添加人
	private String editTime; 		// 修改时间
	private String editBy; 			// 修改人

	public Long getSeqId() {
		return seqId;
	}

	public void setSeqId(Long seqId) {
		this.seqId = seqId;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public Integer getPrice() {
		return price;
	}

	public void setPrice(Integer price) {
		this.price = price;
	}

	public Integer getCrystal() {
		return crystal;
	}

	public void setCrystal(Integer crystal) {
		this.crystal = crystal;
	}

	public Integer getDays() {
		return days;
	}

	public void setDays(Integer days) {
		this.days = days;
	}

	public Integer getRebate() {
		return rebate;
	}

	public void setRebate(Integer rebate) {
		this.rebate = rebate;
	}

	public Integer getTotalNum() {
		return totalNum;
	}

	public void setTotalNum(Integer totalNum) {
		this.totalNum = totalNum;
	}

	public Integer getLeftNum() {
		return leftNum;
	}

	public void setLeftNum(Integer leftNum) {
		this.leftNum = leftNum;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getInputTime() {
		return inputTime;
	}

	public void setInputTime(String inputTime) {
		this.inputTime = inputTime;
	}

	public String getInputBy() {
		return inputBy;
	}

	public void setInputBy(String inputBy) {
		this.inputBy = inputBy;
	}

	public String getEditTime() {
		return editTime;
	}

	public void setEditTime(String editTime) {
		this.editTime = editTime;
	}

	public String getEditBy() {
		return editBy;
	}

	public void setEditBy(String editBy) {
		this.editBy = editBy;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("FinancialPackages [seqId=").append(seqId)
				.append(", packageName=").append(packageName)
				.append(", price=").append(price).append(", crystal=")
				.append(crystal).append(", days=").append(days)
				.append(", rebate=").append(rebate).append(", totalNum=")
				.append(totalNum).append(", leftNum=").append(leftNum)
				.append(", status=").append(status).append(", remark=")
				.append(remark).append(", inputTime=").append(inputTime)
				.append(", inputBy=").append(inputBy).append(", editTime=")
				.append(editTime).append(", editBy=").append(editBy)
				.append("]");
		return builder.toString();
	}

}
