package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.QuestionGameCategory;

public class QuestionGameCategoryBoImpl extends BaseDaoImpl implements QuestionGameCategoryBo {

    private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public int count(QuestionGameCategory question) {
		return baseDao.count(question);
	}

	@Override
	public void deleteById(long id) {
		baseDao.deleteById(QuestionGameCategory.class, id);
	}
	
	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}

	@Override
	public List<QuestionGameCategory> find(QuestionGameCategory question, int pageNo,
			int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		return baseDao.findByObject(QuestionGameCategory.class, question, page);
	}
	 



	@Override
	public QuestionGameCategory findById(long id) {
		return baseDao.findById(QuestionGameCategory.class, id);
	}

	@Override
	public void insert(QuestionGameCategory question) {
		 baseDao.insert(question);
	}

	@Override
	public void update(QuestionGameCategory question) {
		baseDao.updateById(question);
	}
	public  List findBySql(Class clazz, String preSql, List paramList) {
		return baseDao.findBySql(clazz, preSql, paramList);
	}

}
