package com.xunlei.niux.data.vipgame.vo.crystal;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;

/**
 * 水晶兑换元宝
 * 
 * @author HuangGuangHao
 */
@Table(tableName = "crystalExchangeGold", pkFieldName = "seqId", pkFieldAssign = false)
@JsonIgnoreProperties({"seqId", "userId"})
public class CrystalExchangeGold {
	private Long seqId; 			// 主键
	private String userId; 			// 兑换元宝用户ID
	private Integer crystal; 		// 水晶数量
	private String orderId; 		// 订单号
	private Integer gold; 			// 元宝数量
	private String gameId;			// 游戏ID
	private String gameName;		// 游戏名
	private String serverId;		// 区服ID
	private String serverName;		// 区服名称
	private String roleId; 			// 角色ID
	private String roleName;		// 角色名称
	private String exchangeTime;	// 兑换时间
	private Integer status;			// 状态
	@Column(columnName="exchangeTime",isWhereColumn=true,operator=Operator.GE)
	private String beginTime;
	@Column(columnName="exchangeTime",isWhereColumn=true,operator=Operator.LE)
	private String endTime;
	
	public Long getSeqId() {
		return seqId;
	}

	public void setSeqId(Long seqId) {
		this.seqId = seqId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Integer getCrystal() {
		return crystal;
	}

	public void setCrystal(Integer crystal) {
		this.crystal = crystal;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public Integer getGold() {
		return gold;
	}

	public void setGold(Integer gold) {
		this.gold = gold;
	}

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

	public String getGameName() {
		return gameName;
	}

	public void setGameName(String gameName) {
		this.gameName = gameName;
	}

	public String getServerId() {
		return serverId;
	}

	public void setServerId(String serverId) {
		this.serverId = serverId;
	}

	public String getServerName() {
		return serverName;
	}

	public void setServerName(String serverName) {
		this.serverName = serverName;
	}

	public String getRoleId() {
		return roleId;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	public String getExchangeTime() {
		return exchangeTime;
	}

	public void setExchangeTime(String exchangeTime) {
		this.exchangeTime = exchangeTime;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CrystalExchangeGold [seqId=").append(seqId)
				.append(", userId=").append(userId).append(", crystal=")
				.append(crystal).append(", orderId=").append(orderId)
				.append(", gold=").append(gold).append(", gameId=")
				.append(gameId).append(", gameName=").append(gameName)
				.append(", serverId=").append(serverId).append(", serverName=")
				.append(serverName).append(", roleId=").append(roleId)
				.append(", roleName=").append(roleName)
				.append(", exchangeTime=").append(exchangeTime)
				.append(", status=").append(status).append(", beginTime=")
				.append(beginTime).append(", endTime=").append(endTime)
				.append("]");
		return builder.toString();
	}
	
}
