package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportOldGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportPersonDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportTeamDTO;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RebateReportBoImpl implements RebateReportBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String,RebateReportPersonDTO> queryRebateReportPersonByDate(String startDate, String endDate) {
        Map<String,RebateReportPersonDTO> map = new HashMap<String, RebateReportPersonDTO>();
        String sql1 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person," +
                " 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 7 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.inputBy  ";
        String sql2 = " SELECT SUM(r.money) AS finished, SUM(r.rebatemoney) AS rebatemoney, r.inputBy As person," +
                " 0 AS kpi, 0 AS kpiRc, 0 AS kpiYj, 0.0 AS kpirate, 0.0 AS kpiraterc, 0.0 AS kpirateyj, 0.0 as finishedRiChang, 0.0 as finishedYeJi  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 3 and r.vipGrade <= 6 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.inputBy  ";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportPersonDTO> list1 = baseDao.findBySql(RebateReportPersonDTO.class,sql1,params);
        List<RebateReportPersonDTO> list2 = baseDao.findBySql(RebateReportPersonDTO.class,sql2,params);
        for(RebateReportPersonDTO dto:list1){//大R
            RebateReportPersonDTO data = new RebateReportPersonDTO();
            data.setPerson(dto.getPerson());
            data.setFinished(dto.getFinished());
            data.setFinishedRiChang(dto.getFinished());//大R
            data.setFinishedYeJi(0.0);
            data.setRebatemoney(dto.getRebatemoney());
            map.put(dto.getPerson(),data);
        }
        for(RebateReportPersonDTO dto:list2){//中R
            RebateReportPersonDTO data = map.get(dto.getPerson());
            if(data==null){
                data = new RebateReportPersonDTO();
                data.setPerson(dto.getPerson());
                data.setFinished(dto.getFinished());
                data.setFinishedRiChang(0.0);
                data.setFinishedYeJi(dto.getFinished());//中R
                data.setRebatemoney(dto.getRebatemoney());
            }else{
                data.setRebatemoney(data.getRebatemoney()+dto.getRebatemoney());
                data.setFinished(data.getFinished()+dto.getFinished());
                data.setFinishedYeJi(data.getFinishedYeJi() + dto.getFinished());//中R
            }
            map.put(data.getPerson(),data);
        }
        return map;
    }

    /**
     * 查询VIP等级大于等于3（中R以上）的
     */
    @Override
    public RebateReportTeamDTO queryRebateReportByDate(String startDate, String endDate) {
        String sql = " SELECT SUM(r.money) AS finished,r.workType, 0.0 as finishedRiChang, 0.0 as finishedYeJi, r.vipGrade  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE r.vipGrade >= 3 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1)  and r.workType=2  GROUP BY r.vipGrade";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportTeamDTO> list = baseDao.findBySql(RebateReportTeamDTO.class,sql, params);
        RebateReportTeamDTO dto = new RebateReportTeamDTO();
        for(RebateReportTeamDTO teamKpi : list){
            dto.setFinished(dto.getFinished() == null ? teamKpi.getFinished() : dto.getFinished() + teamKpi.getFinished());
            dto.setFinishedRiChang(dto.getFinishedRiChang() == null ? 0.0 : dto.getFinishedRiChang());
            dto.setFinishedYeJi(dto.getFinishedYeJi() == null ? 0.0 : dto.getFinishedYeJi());
            
            if(teamKpi.getVipGrade() >= 7){//大R VipGrade>=7
                dto.setFinishedRiChang(dto.getFinishedRiChang() == null ? 0.0 : dto.getFinishedRiChang() + teamKpi.getFinished());
            }else{//中R  6>=VipGrade>=3
                dto.setFinishedYeJi(dto.getFinishedYeJi() == null ? 0.0 : dto.getFinishedYeJi() + teamKpi.getFinished());
            	
            }
        }
        return dto;
    }



    @Override
    public Map<String,Double> queryRebateReportGameByDate(String startDate, String endDate) {
        Map<String,Double> map = new HashMap<String, Double>();
        String sql = " SELECT SUM(r.money) AS finished, r.gameid, 0 AS kpisale, 0.0 AS salerate,0 AS kpiincome, 0.0 AS income,0.0 AS incomerate,0.0 AS saleincomerate  FROM \n" +
                "(SELECT DISTINCT aporderid FROM rebateorder WHERE orderTime>=? AND orderTime<=?) o \n" +
                "INNER JOIN rebateapply r ON o.aporderid=r.aporderid \n" +
                "WHERE  r.vipGrade >= 3 and (r.checkstatus=-1 OR r.checkstatus=0 OR r.checkstatus=1) and r.workType=2 GROUP BY r.gameid ";
        List<Object> params = new ArrayList<Object>();
        params.add(startDate);
        params.add(endDate);
        List<RebateReportGameDTO> list = baseDao.findBySql(RebateReportGameDTO.class,sql,params);
        for(RebateReportGameDTO dto:list){
            map.put(dto.getGameid(),dto.getFinished());
        }
        return map;
    }

    @Override
    public List<RebateReportOldGameDTO> queryOldGameKpiSumForPerson(String kpiDate) {
        String sql = " SELECT person, SUM(kpi) AS kpitotal, 0.0 AS finished, 0.0 AS kpirate FROM vic_rebate_report_old_game_config WHERE kpiDate=? GROUP BY person ";
        List<Object> params = new ArrayList<Object>();
        params.add(kpiDate);
        return baseDao.findBySql(RebateReportOldGameDTO.class,sql,params);
    }

}
