package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.niux.data.vipgame.vo.Flatno;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.data.vipgame.vo.SpreadinfoBase;

import java.util.ArrayList;
import java.util.List;

public class SpreadinfoBoImpl implements SpreadinfoBo {
	private BaseDao baseDao;
	
	
	public int count(Spreadinfo spreadinfo){
		return baseDao.count(spreadinfo);
	}

    @Override
    public List<Flatno> findFlatnoList() {

        return baseDao.findBySql(Flatno.class, "SELECT DISTINCT flatno FROM spreadinfo");
    }

	@Override
	public List<SpreadinfoBase> getSpreadinfoBase(String flatno, String spreadTabStart, int startValue, int endValue) {

		List<Object> param = new ArrayList<Object>();

		String sql ="SELECT * from (\n" +
				"SELECT *, REPLACE(spreadTab,?,'') as orderNo from spreadinfo_base where flatno=? and spreadTab like ? )" +
				" tmp_spreadbase where 1=1 ";

		param.add(spreadTabStart+"_");
		param.add(flatno);
		param.add(spreadTabStart+"%");

		if(startValue>0){
			sql+=" and  orderNo >= ? ";
			param.add(startValue);
		}

		if(endValue>0){
			sql += " and orderNo <= ? ";
			param.add(endValue);
		}

		sql += " order by orderNo asc ";

		List<SpreadinfoBase> bySql = baseDao.findBySql(SpreadinfoBase.class, sql, param);
		return bySql;
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}
	
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	
	}

	public void insertSpreadInfo(Spreadinfo spreadInfo) {
        checkAdvNo(spreadInfo);
		baseDao.insert(spreadInfo);

	}

    private void checkAdvNo(Spreadinfo spreadInfo) {
        String jumpurl = spreadInfo.getJumpurl();
        String advNoStr = "advNo=" + spreadInfo.getAdvNo();

        if (!jumpurl.contains(advNoStr)) {
            if (jumpurl.endsWith("/")) {
                jumpurl += "?" + advNoStr;
            } else if (jumpurl.endsWith("?")) {
                jumpurl += advNoStr;
            } else if (!jumpurl.contains("?")) {
                jumpurl += "?" + advNoStr;
            } else {
                jumpurl += "&" + advNoStr;
            }

            spreadInfo.setJumpurl(jumpurl);
        }
    }

    public void deleteSpreadInfo(Spreadinfo spreadinfo) {
		baseDao.deleteById(Spreadinfo.class, spreadinfo.getSeqId());
	}

	public Spreadinfo findSpreadInfo(Spreadinfo spreadinfo) {
		Page p = new Page();
		p.addOrder("flatno",OrderType.DESC);
		List<Spreadinfo> list = baseDao.findByObject(Spreadinfo.class, spreadinfo,p );
		if(list.size()>0){
			return list.get(0);
		}
		return null;
	}

	public Spreadinfo findSpreadInfo(long seqid) {
		return baseDao.findById(Spreadinfo.class, seqid);
	}

	public List<Spreadinfo> findSpreadInfoInlist(Spreadinfo spreadinfo,
			PagedFliper fliper) {
		Page page=new Page();
		page.addOrder("flatno",OrderType.DESC);
		page.addOrder("spreadTab", OrderType.DESC);
		page.addOrder("advNo", OrderType.DESC);
		page.setPageNo(fliper.getPageNo());
		page.setPageSize(fliper.getPageSize());
		return baseDao.findByObject(Spreadinfo.class,spreadinfo, page);
	}

	public void updateSpreadinfo(Spreadinfo spreadinfo) {
        checkAdvNo(spreadinfo);

		baseDao.updateById(spreadinfo);
	}
	public void deleteSpreadInfoById(long seqId) {
		baseDao.deleteById(Spreadinfo.class, seqId);
	}

}
