package com.xunlei.niux.data.vipgame.bo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.presql.CountSelect;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;


public class CustomerDetailQueryBoImpl extends BaseDaoImpl implements CustomerDetailQueryBo {

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public int queryForInt(String sql,Object args[]){
		return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public int count(CustomerDetailQuery customer) {
		return super.count(customer);
	}
    public List<CustomerDetailQuery> find(CustomerDetailQuery customer, Page page){
    	return findByObject(CustomerDetailQuery.class,customer, page);
    }
	
	@Override
	public List<CustomerDetailQuery> find(CustomerDetailQuery customer,String sql, Page page) {
		    String birthday = customer.getBirthday();
		    if(birthday != null&&!"".equals(birthday)){
	        	String str[] = birthday.split("-");
	        	birthday = str[1]+"-"+str[2];
	        		sql += " and birthday like '_____"+birthday+"%'";

	        }
		    customer.setBirthday(null);
		return findByObject(CustomerDetailQuery.class,customer, page, sql);
	}
	
	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}
	
	 public List findByObject(Class clazz,String birthday, Object entity, Page page){
	        Select select = new Select(entity, page);
	        String sql =  select.getPreSql();
	        return executeQuery(clazz, sql, select.getParamsList());
	  }

	 public List findByObject(Class clazz, Object obj, Page page,String preSql){
	        List paramsList = new ArrayList();
	        String tableName = DaoUtil.getTableName(obj.getClass());
	        String where = DaoUtil.createWhere(obj, paramsList);
	        if(where.indexOf("where")>-1)
	            where += " and 1=1 ";
	        String order = createOrder(obj, page);
	        String limit = createLimit(page);
	        String sql = preSql+order+limit;
	        return executeQuery(clazz, sql, paramsList);
	 }
	 
	 public String createLimit(Page page){
	    if (!page.isPage()) {
			return "";
		} else {
			int start = (page.getPageNo() - 1) * page.getPageSize();
			return (new StringBuilder(" limit ")).append(start).append(",")
					.append(page.getPageSize()).toString();
		}
	 }
	 
	 public String createOrder(Object obj, Page page){
        if (!page.isOrder())
			return "";
		StringBuilder sb = new StringBuilder();
		List list = page.getOrderList();
		for (Iterator iterator = list.iterator(); iterator.hasNext();) {
			Order order = (Order) iterator.next();
			Field field = DaoUtil.getDeclaredField(obj.getClass(), order
					.getOrderName());
			String columnName = DaoUtil.getColumnName(field);
			sb.append(",").append(columnName);
			if (order.getType() == OrderType.DESC)
				sb.append(" desc");
			else
				sb.append(" asc");
		}

		String orderStr = sb.toString();
		if (orderStr.startsWith(","))
			orderStr = orderStr.substring(1);
		if (orderStr.length() > 0)
			orderStr = (new StringBuilder(" order by ")).append(orderStr)
					.toString();
		return orderStr;
	}
	@Override
	public CustomerDetailQuery findById(long id) {
		return baseDao.findById(CustomerDetailQuery.class, id);
	}

	@Override
	public void insert(CustomerDetailQuery customer) {
		baseDao.insert(customer);
	}

	@Override
	public void update(CustomerDetailQuery customer) {
		baseDao.updateById(customer);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}

	public void execute(String sql, List<Object> list){
		baseDao.execute(sql, list);
	}
}
