/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.bonus;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.bonus.AuctionProductBo;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BaseProduct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AuctionProductBoImpl
implements AuctionProductBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public AuctionProduct findOne(long auctionProductId) {
        return (AuctionProduct)this.baseDao.findById(AuctionProduct.class, (Number)auctionProductId);
    }

    @Override
    public List<AuctionProduct> finds(AuctionProduct product, Page page) {
        return this.baseDao.findByObject(AuctionProduct.class, (Object)product, page);
    }

    @Override
    public int count(AuctionProduct product) {
        return this.baseDao.count((Object)product);
    }

    @Override
    public void insert(AuctionProduct auctionProduct) {
        BaseProduct baseProduct = (BaseProduct)this.baseDao.findById(BaseProduct.class, (Number)auctionProduct.getBaseProductId());
        if (baseProduct == null) {
            throw new RuntimeException("\u4ea7\u54c1\u7c7b\u578b\u7f16\u7801[" + auctionProduct.getBaseProductId() + "]\u4e0d\u5b58\u5728");
        }
        auctionProduct.setProductType(baseProduct.getProductType());
        if (baseProduct.getIsFixedBaseUnitNum().booleanValue()) {
            auctionProduct.setBaseUnitNum(baseProduct.getBaseUnitNum());
        }
        auctionProduct.setBiddedUserNum(0);
        auctionProduct.setBiddedMinBonusNum(0);
        auctionProduct.setAuctionTimes(0);
        if (auctionProduct.getAuctionProductNum() == null) {
            auctionProduct.setAuctionProductNum(0);
        }
        this.checkAuctionProductValid(auctionProduct);
        this.baseDao.insert((Object)auctionProduct);
    }

    @Override
    public void updateSomeInfo(AuctionProduct auctionProduct) {
        AuctionProduct targetAuctionProduct = this.lockQueryAuctionProduct(auctionProduct.getAuctionProductId());
        if (targetAuctionProduct == null) {
            throw new RuntimeException("\u7ade\u62cd\u4ea7\u54c1Id[" + auctionProduct.getAuctionProductId() + "\u5bf9\u5e94\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        int status = this.auctionProductStatus(targetAuctionProduct);
        if (status == 0) {
            BaseProduct baseProduct = (BaseProduct)this.baseDao.findById(BaseProduct.class, (Number)auctionProduct.getBaseProductId());
            targetAuctionProduct.setProductType(baseProduct.getProductType());
            if (baseProduct.getIsFixedBaseUnitNum().booleanValue()) {
                targetAuctionProduct.setBaseUnitNum(baseProduct.getBaseUnitNum());
            } else {
                targetAuctionProduct.setBaseUnitNum(auctionProduct.getBaseUnitNum());
            }
            targetAuctionProduct.setProductName(auctionProduct.getProductName());
            targetAuctionProduct.setAuctionProductNum(auctionProduct.getAuctionProductNum());
            targetAuctionProduct.setGameId(auctionProduct.getGameId());
            targetAuctionProduct.setProductLot(auctionProduct.getProductLot());
            targetAuctionProduct.setBaseBonusNum(auctionProduct.getBaseBonusNum());
            targetAuctionProduct.setOneAddBonusNum(auctionProduct.getOneAddBonusNum());
            targetAuctionProduct.setStartAuctionTime(auctionProduct.getStartAuctionTime());
            targetAuctionProduct.setEndAuctionTime(auctionProduct.getEndAuctionTime());
            targetAuctionProduct.setIsSelectFenQu(auctionProduct.getIsSelectFenQu());
            targetAuctionProduct.setIsSelectRole(auctionProduct.getIsSelectRole());
        } else if (status == 1) {
            targetAuctionProduct.setEndAuctionTime(auctionProduct.getEndAuctionTime());
        }
        this.checkAuctionProductValid(targetAuctionProduct);
        targetAuctionProduct.setPicUrl(auctionProduct.getPicUrl());
        targetAuctionProduct.setSimpleDesc(auctionProduct.getSimpleDesc());
        targetAuctionProduct.setDetailedDesc(auctionProduct.getDetailedDesc());
        targetAuctionProduct.setDisplaySort(auctionProduct.getDisplaySort());
        targetAuctionProduct.setIsDisplay(auctionProduct.getIsDisplay());
        targetAuctionProduct.setEditBy(auctionProduct.getEditBy());
        targetAuctionProduct.setEditTime(auctionProduct.getEditTime());
        this.baseDao.updateById((Object)targetAuctionProduct);
    }

    private void checkAuctionProductValid(AuctionProduct auctionProduct) {
        if (auctionProduct.getBaseUnitNum() == null || auctionProduct.getBaseUnitNum() <= 0.0) {
            throw new RuntimeException("\u57fa\u672c\u5355\u4f4d\u6570\u76ee\u5fc5\u987b\u5927\u4e8e0");
        }
        if (auctionProduct.getProductName() == null || "".equals(auctionProduct.getProductName())) {
            throw new RuntimeException("\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (auctionProduct.getAuctionProductNum() == null) {
            throw new RuntimeException("\u7ade\u62cd\u5546\u54c1\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (auctionProduct.getBaseBonusNum() == null || auctionProduct.getBaseBonusNum() <= 0) {
            throw new RuntimeException("\u5e95\u4ef7\u5fc5\u987b\u5927\u4e8e0");
        }
        if (auctionProduct.getOneAddBonusNum() == null || auctionProduct.getOneAddBonusNum() <= 0) {
            throw new RuntimeException("\u6bcf\u6b21\u52a0\u4ef7\u5fc5\u987b\u5927\u4e8e0");
        }
        if (auctionProduct.getStartAuctionTime() == null || "".equals(auctionProduct.getStartAuctionTime())) {
            throw new RuntimeException("\u5f00\u62cd\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (auctionProduct.getEndAuctionTime() == null || "".equals(auctionProduct.getEndAuctionTime())) {
            throw new RuntimeException("\u7ed3\u675f\u7ade\u62cd\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (auctionProduct.getStartAuctionTime().compareTo(auctionProduct.getEndAuctionTime()) >= 0) {
            throw new RuntimeException("\u7ade\u62cd\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u62cd\u65f6\u95f4");
        }
    }

    @Override
    public void delete(long auctionProductId) {
        AuctionProduct auctionProduct = this.lockQueryAuctionProduct(auctionProductId);
        int status = this.auctionProductStatus(auctionProduct);
        if (status == 0) {
            this.baseDao.deleteById(AuctionProduct.class, (Number)auctionProductId);
            return;
        }
        throw new RuntimeException("\u7ade\u62cd\u72b6\u6001\uff1a" + status + "\u5904\u4e8e\u7ade\u62cd\u9636\u6bb5\u6216\u8005\u4e00\u7ed3\u675f\u7ade\u62cd");
    }

    public int auctionProductStatus(AuctionProduct auctionProduct) {
        String nowStr = sdf.format(new Date());
        if (auctionProduct.getStartAuctionTime().compareTo(nowStr) > 0) {
            return 0;
        }
        if (auctionProduct.getEndAuctionTime().compareTo(nowStr) > 0) {
            return 1;
        }
        return 2;
    }

    public AuctionProduct lockQueryAuctionProduct(long auctionProductId) {
        String sql = "select * from auctionproduct where auctionProductId=? for update";
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(auctionProductId);
        List list = this.baseDao.executeQuery(AuctionProduct.class, sql, paramList);
        return list == null || list.size() == 0 ? null : (AuctionProduct)list.get(0);
    }
}

