package com.xunlei.niux.data.vipgame.bo.tasks;

import com.xunlei.niux.data.vipgame.dao.tasks.TaskDutyConfigDao;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-11.
 */
public class TaskDutyConfigBoImpl implements TaskDutyConfigBo{


    @Autowired
    private TaskDutyConfigDao taskDutyConfigDao;

    @Override
    public Map<Integer,TaskDutyConfig> getTaskDutyConfigByTaskIdList(List<Integer> taskIdList) {
        List<TaskDutyConfig> taskDutyConfigList = taskDutyConfigDao.getTaskDutyConfigByTaskIdList(taskIdList);
        Map<Integer,TaskDutyConfig> map = new HashMap<Integer, TaskDutyConfig>();
        if(CollectionUtils.isEmpty(taskDutyConfigList)){
            return map;
        }

        for(TaskDutyConfig taskDutyConfig : taskDutyConfigList){
            map.put(taskDutyConfig.getSeqId(),taskDutyConfig);
        }

        return map;
    }

    @Override
    public Map<Integer, TaskDutyConfig> getAllTaskDutyConfig() {
        List<TaskDutyConfig> taskDutyConfigList = taskDutyConfigDao.getAllTaskDutyConfig();
        Map<Integer,TaskDutyConfig> map = new HashMap<Integer, TaskDutyConfig>();
        if(CollectionUtils.isEmpty(taskDutyConfigList)){
            return map;
        }

        for(TaskDutyConfig taskDutyConfig : taskDutyConfigList){
            map.put(taskDutyConfig.getSeqId(),taskDutyConfig);
        }

        return map;
    }
}
