package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.SpreadInfoTime;

import java.util.List;

/**
 * @author hezhong
 */
public class SpreadInfoTimeBoImpl implements SpreadInfoTimeBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void update(SpreadInfoTime spreadInfoTime) {
        baseDao.updateById(spreadInfoTime);
    }

    @Override
    public void insert(SpreadInfoTime spreadInfoTime) {
        baseDao.insert(spreadInfoTime);
    }

    @Override
    public void delete(Integer seqid) {
        baseDao.deleteById(SpreadInfoTime.class, seqid);
    }

    @Override
    public List<SpreadInfoTime> findAll() {
        return baseDao.findBySql(SpreadInfoTime.class, "select * from spreadinfotime where isinvalid = 0 order by spreaddate asc");
    }

    @Override
    public SpreadInfoTime find(Integer seqid) {
        return baseDao.findById(SpreadInfoTime.class, seqid);
    }

    @Override
    public List<SpreadInfoTime> find(SpreadInfoTime spreadInfoTime, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("spreaddate", OrderType.DESC);

        return baseDao.findByObject(SpreadInfoTime.class, spreadInfoTime, page);
    }

    @Override
    public int count(SpreadInfoTime spreadInfoTime) {
        return baseDao.count(spreadInfoTime);
    }
}
