package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;

import java.util.List;

/**
 * @author hezhong
 */
public class GamePayInfoBoImpl implements GamePayInfoBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<GamePayInfo> find(GamePayInfo gamePayInfo, int start, int limit) {
        Page page = new Page();
        page.setPageNo(start);
        page.setPageSize(limit);

        return baseDao.findByObject(GamePayInfo.class, gamePayInfo, page);
    }

    @Override
    public GamePayInfo findById(long seqId) {
        return baseDao.findById(GamePayInfo.class, seqId);
    }

    @Override
    public void insert(GamePayInfo gamePayInfo) {
        baseDao.insert(gamePayInfo);
    }

    @Override
    public void update(GamePayInfo gamePayInfo) {
        baseDao.updateById(gamePayInfo);
    }

    @Override
    public int count(GamePayInfo gamePayInfo) {
        return baseDao.count(gamePayInfo);
    }

    @Override
    public GamePayInfo findByGameId(String gameId) {

        if(gameId==null || "".equals(gameId)) {
            return null;
        }

        GamePayInfo gamePayInfo = new GamePayInfo();
        gamePayInfo.setGameid(gameId);

        List<GamePayInfo> list = baseDao.findByObject(GamePayInfo.class, gamePayInfo, new Page());

        return (list!=null&&list.size()>0)?list.get(0):null;
    }
}
