package com.xunlei.niux.data.vipgame.bo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CardBizi;


public class CardBiziBoImpl extends BaseDaoImpl implements CardBiziBo{
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public void insert(CardBizi cb) {
		baseDao.insert(cb);
	}

	public void update(CardBizi cb) {
		baseDao.updateById(cb);
	}
	public int count(CardBizi cb) {
		return baseDao.count(cb);
	}

	public List<CardBizi> find(CardBizi cb, Page page) {
		if(cb==null){
			return new ArrayList<CardBizi>();
		}
		return baseDao.findByObject(CardBizi.class, cb, page);
	}

	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}
	public CardBizi find(long seqid) {
		return baseDao.findById(CardBizi.class, seqid);
	}


	public List<CardBizi> find(CardBizi cb, String sql, Page page) {
		return findByObject(CardBizi.class,cb, page, sql);
	}

	 public List findByObject(Class clazz, Object obj, Page page,String preSql){
	        List paramsList = new ArrayList();
	        String tableName = DaoUtil.getTableName(obj.getClass());
	        String where = DaoUtil.createWhere(obj, paramsList);
	        String order = createOrder(obj, page);
	        String limit = createLimit(page);

	        String sql = where +preSql+order+limit;
	        if(sql.indexOf("where")==-1){
	        	sql = "where 1=1 "+sql;
	        }
	        sql = "select * from cardbizi "+sql;
	        
	        if(sql.indexOf("month =?")>-1){
	        	sql = sql.replace("month =", "'2013-01' <");
	        }
	        logger.info("sql================>"+sql);
	        return executeQuery(clazz, sql, paramsList);
	 }
	 
	 public String createLimit(Page page){
	    if (!page.isPage()) {
			return "";
		} else {
			int start = (page.getPageNo() - 1) * page.getPageSize();
			return (new StringBuilder(" limit ")).append(start).append(",")
					.append(page.getPageSize()).toString();
		}
	 }
		 
	  public String createOrder(Object obj, Page page){
	        if (!page.isOrder())
				return "";
			StringBuilder sb = new StringBuilder();
			List list = page.getOrderList();
			for (Iterator iterator = list.iterator(); iterator.hasNext();) {
				Order order = (Order) iterator.next();
				Field field = DaoUtil.getDeclaredField(obj.getClass(), order
						.getOrderName());
				String columnName = DaoUtil.getColumnName(field);
				sb.append(",").append(columnName);
				if (order.getType() == OrderType.DESC)
					sb.append(" desc");
				else
					sb.append(" asc");
			}

			String orderStr = sb.toString();
			if (orderStr.startsWith(","))
				orderStr = orderStr.substring(1);
			if (orderStr.length() > 0)
				orderStr = (new StringBuilder(" order by ")).append(orderStr)
						.toString();
			return orderStr;
		}
}
