package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.GameInsideplace;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
public class GameInsideplaceDaoImpl extends BaseDaoImpl implements GameInsideplaceDao {
    private static final String ORDER =
            "UPDATE gameinsideplace SET DISPLAYORDER = CONCAT('${order}', SUBSTRING(DISPLAYORDER, ${length}))  WHERE " +
                    " gameid = '${gameid}' and" +
                    " titleid LIKE '${titleId}%' ";


    @Override
    public Map<String, String> getMaxId(String titlePid, String gameid) {

        String sql = "select max(titleid) titleid, max(displayOrder) displayOrder " +
                "from gameinsideplace where titlepid = ? and gameid = ? ";
        Object[] args = new Object[]{titlePid, gameid};

        final Map<String, String> date = new HashMap<String, String>();
        getJdbcTemplate().query(sql, args, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                date.put("titleid", resultSet.getString(1));
                date.put("displayOrder", resultSet.getString(2));
            }
        });

        return date;
    }

    @Override
    public boolean exchangeOrder(long seqid, String way) {
        GameInsideplace gameInsideplace = findById(GameInsideplace.class, seqid);

        if(gameInsideplace == null) {
            return false;
        }

        String query = new StringBuilder()
                .append(" SELECT DISPLAYORDER, TITLEID FROM gameinsideplace WHERE ")
                .append(" titlepid='").append(gameInsideplace.getTitlepid()).append("' ")
                .append(" and gameid = '").append(gameInsideplace.getGameid()).append("' ")
                .append(" and displayOrder ")
                .append("1".equals(way) ? " < " : " > ").append(gameInsideplace.getDisplayOrder())
                .append(" ORDER BY DISPLAYORDER ")
                .append("1".equals(way) ? " desc " : " asc ")
                .append(" limit 1")
                .toString();

        final Map<String, String> date = new HashMap<String, String>();
        getJdbcTemplate().query(query, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                date.put("DISPLAYORDER", resultSet.getString(1));
                date.put("TITLEID", resultSet.getString(2));
            }
        });

        if(date.size() == 0) {
            return false;
        }

        String sqls[] = new String[2];
        sqls[0] = new String(ORDER).replace("${order}", date.get("DISPLAYORDER"))
                .replace("${length}", String.valueOf(gameInsideplace.getDisplayOrder().length() + 1))
                .replace("${gameid}", gameInsideplace.getGameid())
                .replace("${titleId}", gameInsideplace.getTitleid());

        sqls[1] = new String(ORDER).replace("${order}", gameInsideplace.getDisplayOrder())
                .replace("${length}", String.valueOf(gameInsideplace.getDisplayOrder().length() + 1))
                .replace("${gameid}", gameInsideplace.getGameid())
                .replace("${titleId}", date.get("TITLEID"));

        getJdbcTemplate().batchUpdate(sqls);
        return true;
    }

    @Override
    public String getOrderIdByTitleId(String titleId, String gameid) {

        List<String> strLst;

        String sql = "select displayOrder from gameinsideplace where titleid = ? and gameid = ? ";
        Object[] args = new Object[]{titleId, gameid};

        strLst =  getJdbcTemplate().queryForList(sql, args, String.class);

        if(strLst.size() == 0) {
            return null;
        } else {
            return strLst.get(0);
        }
    }

}
