package com.xunlei.niux.data.vipgame.bo.lottery;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.GiftTypeEnum;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-10
 * Time: 下午5:48
 * To change this template use File | Settings | File Templates.
 */
public class LotteryBoImpl implements LotteryBo{

    @Override
    public Map<String, Object> getRealLotteryGiftByActNo(String actNo) {
        Map<String,Object> map = new HashMap<String,Object>();
        if(StringUtils.isEmpty(actNo)){
            return map;
        }

        //获取lotterygift
        LotteryGift query = new LotteryGift();
        query.setActNo(actNo);
        query.setIsValid(true);
        query.setGiftType(GiftTypeEnum.GOTGIFT);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.ESC);
        List<LotteryGift> giftList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);

        if(CollectionUtils.isEmpty(giftList)){
            return map;
        }

        LotteryGift lotteryGift = giftList.get(0);
        String giftId = lotteryGift.getGiftId();
        Gift gift = getGiftById(giftId);

        LotteryActivity activity = getLotteryActivityByActNo(actNo);
        if(activity == null){
            return map;
        }


        map.put("id",lotteryGift.getGiftId());
        map.put("name",lotteryGift.getGiftName());
        map.put("desc",gift.getSimpleDesc()==null?"":gift.getSimpleDesc());
        map.put("price",gift.getProductUnitPrice());
        map.put("amount",lotteryGift.getTotalCount());
        map.put("vipLevel",activity.getJinKaVipNum());
        map.put("img",lotteryGift.getPhoto()==null?"":lotteryGift.getPhoto());

        return map;
    }

    private Gift getGiftById(String giftId){
        if(StringUtils.isEmpty(giftId)){
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));

        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);

        return gift;
    }

    private LotteryActivity getLotteryActivityByActNo(String actNo){
        if(StringUtils.isEmpty(actNo)){
            return null;
        }

        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        query.setIsValid(true);

        List<LotteryActivity> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());

        if(CollectionUtils.isEmpty(list)){
            return null;
        }
        return list.get(0);
    }
}
