package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.dao.MobileGuildDao;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MobileGameApkDto;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildUser;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.HttpClientUtil;
import com.xunlei.niux.easyutils.sign.SignUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by Dean on 2016/4/21.
 */
@Service
public class MobileGuildBoImpl implements MobileGuildBo {

    private static final Logger logger = Logger.getLogger(MobileGuildBoImpl.class.getName());

    private static final String downloadurl = "http://preloaddown.boxsvr.niu.xunlei.com/webgame/";
    private static final String callbackurl = "http://dy.niu.xunlei.com/guild/speadCallBack.do";

    private static final String apkPath="/usr/local/htdocs/xlniuxcentersvr2/pack.sh";

    @Autowired
    private MobileGuildDao mobileGuildDao;

    public List<GuildGameDto> getGuildGames(long userId){
        return mobileGuildDao.getGuildGames(userId);
    }

    public List<MobileGuildSpreadDTO> getGuildSpread(long uid,String seqIds, int pageIndex, int pageSize){
        return mobileGuildDao.getGuildSpread(uid,seqIds,pageIndex,pageSize);
    }

    public int countGuildSpread(long uid,String seqIds){
        return mobileGuildDao.countGuildSpread(uid,seqIds);
    }

    private static Random random = getRandom();
    /**
     *  公会打包
     * @param uid
     * @param gameIds
     */
    public void addPackageSpead(long uid,String gameIds) throws Exception{

        Map<String, String> params = new HashMap<String, String>();
        params.put("agentId", uid + "");
        params.put("bizNo", "000001");
        String sign = SignUtil.sign(params, "B1kRlQWSoPCIM8xm");
        String urlnb = "http://basenb.niu.xunlei.com/currency/replace/queryagentbyid.do?resptype=plain&agentId=" + uid+ "&bizNo=000001&sign=" + sign;
        logger.info("/addPackageSpead queryagentbyid.do url=" + urlnb);
        String ret = HttpClientUtil.get(urlnb);
        logger.info("/addPackageSpead queryagentbyid.do ret=" + ret);
        JSONObject jsonObject = null;

        jsonObject = new JSONObject(ret);
        int code = jsonObject.getInt("rtn");
        JSONObject data = jsonObject.getJSONObject("data");
        String channelId=null;
        if (code != 0) {
            throw new XLRuntimeException("用户不存在");
        } else {
            String isGuild=data.getString("isGuild");
            channelId=data.getString("advNo");
            if(!"true".equals(isGuild)||StringUtils.isEmpty(channelId)){
                throw new XLRuntimeException("用户不存在");
            }
        }

        String gameIdsDot=getDotStr(gameIds);
        //游戏apk版本号
        List<MobileGameApkDto> apks=FacadeFactory.INSTANCE.getMobileGuildBo().getGameApk(gameIdsDot);
        Map<String,MobileGameApkDto> apkMap=new HashMap<String,MobileGameApkDto>() ;
        for(MobileGameApkDto mobileGameApkDto:apks){
            apkMap.put(mobileGameApkDto.getGameId(),mobileGameApkDto);
        }
        //已经打包过的游戏
        MobileGuildSpread mobileGuildSpread_query=new MobileGuildSpread();
        mobileGuildSpread_query.setGuildUserId(uid);
        List<MobileGuildSpread> speadList= mobileGuildDao.getPackagedSpreads(null,null,uid+"");

        Map<String,MobileGuildSpread> spreadMap=new HashMap<String,MobileGuildSpread>() ;
        String[] games=gameIds.split(",");

        for(MobileGuildSpread mobileGuildSpread:speadList){
            spreadMap.put(mobileGuildSpread.getGameId(),mobileGuildSpread);
            //更新已经打包数据的不选中状态
            boolean flag=false;
            for(String gameId:games){
                if(gameId.equals(mobileGuildSpread.getGameId())){
                    flag=true;
                    break;
                }
            }
            if(!flag){
                mobileGuildSpread.setHasChecked(false);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
                logger.info("packageSpead HasChecked false gameId="+mobileGuildSpread.getGameId()+" userid="+uid);
            }
        }

        //过滤掉不需要重新打包的游戏
        List<String> packageList=new ArrayList<String>();
        for(String gameId:games){
            MobileGameApkDto mobileGameApkDto=apkMap.get(gameId);
            if(null!=mobileGameApkDto){
                String nowApkVersion=getVersion(mobileGameApkDto.getApkName());
                MobileGuildSpread mobileGuildSpread=spreadMap.get(gameId);
                //版本号不对应，或者没有成功打包记录的游戏  需要打包操作
                if(null==mobileGuildSpread||!mobileGuildSpread.getAppVersion().equals(nowApkVersion)||!mobileGuildSpread.getHasFinished()){
                    packageList.add(gameId);
                }else{
                    mobileGuildSpread.setHasChecked(true);
                    FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
                    logger.info("packageSpead HasChecked true gameId="+mobileGuildSpread.getGameId()+" userid="+uid);
                }
            }
        }
        SimpleDateFormat sft=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowStr=sft.format(new Date());
        StringBuffer gameIdsb=new StringBuffer();
        StringBuffer gameNosb=new StringBuffer();
        StringBuffer apkNamesb=new StringBuffer();
        StringBuffer loginKeysb=new StringBuffer();
        StringBuffer seqIdsb=new StringBuffer();
        for(String gameId:packageList){
            MobileGuildSpread mobileGuildSpread=spreadMap.get(gameId);
            MobileGameApkDto mobileGameApkDto=apkMap.get(gameId);
            MobileGuildSpread spread=null;
            String guiidApkName=getGuiidApkName(mobileGameApkDto.getApkName(),channelId);
            String url=downloadurl+mobileGameApkDto.getGameNo()+"/"+guiidApkName;

            MobileGuildSpread mobileGuildSpread_db=null;
            //新游打包
            if(null==mobileGuildSpread){
                spread=new MobileGuildSpread();
                spread.setAppVersion(getVersion(mobileGameApkDto.getApkName()));
                spread.setGameId(gameId);
                spread.setAppSize(mobileGameApkDto.getAppSize());
                spread.setDownloadUrl(url);
                spread.setGuildUserId(uid);
                spread.setPlatform("安卓");
                spread.setChannelId(channelId);
                spread.setApkId(mobileGameApkDto.getApkId());
                spread.setHasFinished(false);
                spread.setHasChecked(true);
                spread.setInputTime(nowStr);
                spread=changeShortUrl(spread,channelId);
                FacadeFactory.INSTANCE.getBaseSo().addObject(spread);
                //重新打包
            }else{
                spread=mobileGuildSpread;
                spread.setAppVersion(getVersion(mobileGameApkDto.getApkName()));
                spread.setAppSize(mobileGameApkDto.getAppSize());
                spread.setHasFinished(false);
                spread.setHasChecked(true);
                spread.setDownloadUrl(url);
                spread.setInputTime(nowStr);
                spread=changeShortUrl(spread,channelId);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(spread);
            }
            mobileGuildSpread_db=FacadeFactory.INSTANCE.getBaseSo().findObject(spread);

            loginKeysb.append(getLoginKey(mobileGameApkDto.getGameId())).append(",");
            gameNosb.append(mobileGameApkDto.getGameNo()).append(",");
            gameIdsb.append(mobileGameApkDto.getGameId()).append(",");
            String apkName=mobileGameApkDto.getApkName().replace(".apk","");
            apkNamesb.append(apkName).append(",");
            if(null!=mobileGuildSpread_db){
                seqIdsb.append(mobileGuildSpread_db.getSeqId()).append(",");
            }
        }
        String gameids=subDotStr(gameIdsb.toString());
        String gameNos=subDotStr(gameNosb.toString());
        String apkNames=subDotStr(apkNamesb.toString());
        String loginKeys=subDotStr(loginKeysb.toString());
        String seqIds=subDotStr(seqIdsb.toString());
        packageSpead(callbackurl,channelId,gameids,gameNos,apkNames,loginKeys,seqIds);
    }

    private String getVersion(String apkName){
        apkName=apkName.replace(".apk","");
        String[] arr=apkName.split("_");
        if(arr.length>1){
            return arr[1];
        }
        return "";
    }

    public static synchronized String createAdvNo(){
        String orderId = createAdvNo(random);
        return orderId;
    }

    private static String createAdvNo(Random random) {
        double r = random.nextDouble();
        String s = new Double(r).toString().substring(3, 13);
        String orderId = new SimpleDateFormat("yyyyMMdd").format(new Date());
        orderId = orderId + s;
        return orderId;
    }

    private static Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        Timer timer = new Timer();
        // 一小时运行一次
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                long now = DatetimeUtil.parseTimeByYYYYMMDDHHMMSS(DatetimeUtil
                        .now());
                random.setSeed(now);
            }
        }, 0, 1 * 60 * 60 * 1000);
        return random;
    }

    private void deleteInfos(String gameId,String channelId,String shortUrl){
        CommonSpreadInfo  query = new CommonSpreadInfo();
        query.setAdvNo(channelId);
        query.setGameId(gameId);
//		query.setVersion(version);
        query.setShortUrl(shortUrl);
        List<CommonSpreadInfo> infos = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for(CommonSpreadInfo info : infos){
            FacadeFactory.INSTANCE.getBaseSo().deleteById(CommonSpreadInfo.class, info.getSeqId());
        }
    }

    private MobileGuildSpread changeShortUrl(MobileGuildSpread mobileGuildSpread,String channelId){
        String shortUrl="http://jump2.niu.xunlei.com:8080/"+ mobileGuildSpread.getGameId() + "/" + channelId;
        deleteInfos(mobileGuildSpread.getGameId(),channelId,shortUrl);
        CommonSpreadInfo csi = new CommonSpreadInfo();
        csi.setAdvNo(channelId);
        csi.setJumpType(1);
        csi.setGameId(mobileGuildSpread.getGameId());
        String jumpAdvNo = createAdvNo();
        csi.setJumpAdvNo(jumpAdvNo);
        csi.setShortUrl(shortUrl);
        csi.setJumpUrl(mobileGuildSpread.getDownloadUrl());
        csi.setMuliPhotoUrl("");
        csi.setVersion(mobileGuildSpread.getAppVersion());
        csi.setIsValid(true);
        csi.setRecordTime(DateUtil.formatNowByDefault());
        FacadeFactory.INSTANCE.getBaseSo().addObject(csi);
        mobileGuildSpread.setDownloadUrl(csi.getShortUrl());
        return mobileGuildSpread;
    }

    private List<MobileGuildSpread> getPackagedSpreadsDb(List<MobileGuildSpread> dataList){
        StringBuffer apkIdsStr=new StringBuffer();
        StringBuffer gameidsStr=new StringBuffer();
        StringBuffer uidsStr=new StringBuffer();
        for(MobileGuildSpread mobileGuildSpread:dataList){
            apkIdsStr.append(mobileGuildSpread.getApkId()).append(",");
            gameidsStr.append("'"+mobileGuildSpread.getGameId()+"'").append(",");
            uidsStr.append(mobileGuildSpread.getGuildUserId()).append(",");
        }
        String apkIds=subDotStr(apkIdsStr.toString());
        String gameids=subDotStr(gameidsStr.toString());
        String uids=subDotStr(uidsStr.toString());
        return mobileGuildDao.getPackagedSpreads(apkIds,gameids,uids);
    }


    private void packageSpead(String callBackUrl,String chanelId,String gameids,String gameNos,String apkNames,String loginKeys,String seqIds){
       /* try {
            Runtime.getRuntime().exec(apkPath+"  "+callBackUrl+"  "+chanelId+"  "+gameNos+"  "+apkNames+"  "+loginKeys);
            logger.info("packageGuildSpead success "+"callBackUrl="+callBackUrl+",chanelId="+chanelId+",gameNos="+gameNos
                    +",apkNames="+apkNames+",loginKeys="+loginKeys);
        } catch (IOException e) {
            logger.error("packageGuildSpead IOException "+"callBackUrl="+callBackUrl+",chanelId="+chanelId+",gameNos="+gameNos
                    +",apkNames="+apkNames+",loginKeys="+loginKeys);
            e.printStackTrace();
        }*/
        String url="http://123.150.216.144:8080/xlniuxapkpackage/packageGuildApk?channelId="+chanelId+"&gameIds="+gameids+
            "&gameNos="+gameNos+"&apkNames="+apkNames+"&loginKeys="+loginKeys+"&seqIds="+seqIds+"&callBackUrl="+callBackUrl;
        //String url="http://10.10.10.203:8087/xlniuxapkpackage/packageGuildApk?channelId="+chanelId+"&gameIds="+gameids+
               // "&gameNos="+gameNos+"&apkNames="+apkNames+"&loginKeys="+loginKeys+"&seqIds="+seqIds+"&callBackUrl="+callBackUrl;
        String response=HttpClientUtil.get(url);
        logger.info("packageSpead pack url="+url+",ret="+response);
    }

    /**
     * 打包完成回调
     * @param seqIds
     */
    public void updateSpead(String seqIds){
        List<MobileGuildSpread> list=FacadeFactory.INSTANCE.getMobileGuildBo().getGuildSpread(0,seqIds);
        for(MobileGuildSpread mobileGuildSpread:list){
            if(!mobileGuildSpread.getHasFinished()){
                mobileGuildSpread.setHasFinished(true);
                mobileGuildSpread.setHasChecked(true);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
            }
        }
    }


    public List<MobileGuildSpread> getGuildSpread(long uid,String seqIds){
        return mobileGuildDao.getGuildSpread(uid,seqIds);
    }

    public List<MobileGuildSpreadDTO> getGuildInfo(String gameIds){
        return mobileGuildDao.getGuildGameInfo(gameIds);
    }

    public List<MobileGameApkDto> getGameApk(String gameIds){
        return mobileGuildDao.getGameApk(gameIds);
    }

    private MobileGuildSpread bulidMobileGuildSpread(MobileGuildSpreadDTO mobileGuildSpreadDTO,long uid,String url, MobileGuildUser user){
        MobileGuildSpread spread=new MobileGuildSpread();
        spread.setAppVersion(mobileGuildSpreadDTO.getAppVersion());
        spread.setGameId(mobileGuildSpreadDTO.getGameId());
        spread.setAppSize(mobileGuildSpreadDTO.getAppSize());
        spread.setDownloadUrl(url);
        spread.setGuildUserId(uid);
        spread.setPlatform("安卓");
        spread.setChannelId(user.getChanelId());
        spread.setApkId(mobileGuildSpreadDTO.getApkId());
        spread.setHasFinished(false);
        return spread;
    }

    private String getLoginKey(String gameid){
        GameXmlMeta query = new GameXmlMeta();
        query.setNewgameid(gameid);
        GameXmlMeta meta = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if(meta == null)return null;
        return meta.getLoginKey();
    }

    private String getGuiidApkName(String apkName,String chanelId){
        String pathName=null;
        apkName = apkName.replace(".apk", "");
        pathName = apkName+"_"+chanelId+".apk";
        return pathName;
    }


    public String getDotStr(String strs){
        strs=strs.replace("，",",");
        String[] spells=strs.split(",");
        StringBuffer sb=new StringBuffer();
        for(String str:spells){
            if(StringUtils.isNotEmpty(str)) {
                sb.append("'" + str + "',");
            }
        }
        strs=sb.toString();
        if(strs.endsWith(",")){
            strs=strs.substring(0,strs.length()-1);
        }
        return strs;
    }

    public String subDotStr(String str){
        if(StringUtils.isNotEmpty(str)&&str.endsWith(",")){
            str=str.substring(0,str.length()-1);
        }
        return str;
    }

}
