package com.xunlei.niux.data.vipgame.bo.clientgame;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.clientgame.CallRecord;

public class CallRecordBoImpl implements CallRecordBo {
	
	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	@Override
	public int count(CallRecord callRecord) {
		return baseDao.count(callRecord);
	}

	@Override
	public void deleteById(long id) {
        baseDao.deleteById(CallRecord.class, id);
	}

	@Override
	public List<CallRecord> find(CallRecord callRecord, int pageNo, int pageSize) {
		Page page = new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("inputtime", OrderType.DESC);
		return baseDao.findByObject(CallRecord.class, callRecord, page);
	}

	@Override
	public CallRecord findById(long id) {
		return baseDao.findById(CallRecord.class, id);
	}

	@Override
	public void insert(CallRecord callRecord) {
        baseDao.insert(callRecord);
	}

	@Override
	public void update(CallRecord callRecord) {
        baseDao.updateById(callRecord);
	}
}
