/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.MobileGuildBo;
import com.xunlei.niux.data.vipgame.dao.MobileGuildDao;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MobileGameApkDto;
import com.xunlei.niux.data.vipgame.dto.MobileGuildSpreadDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildSpread;
import com.xunlei.niux.data.vipgame.vo.mobileguild.MobileGuildUser;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.HttpClientUtil;
import com.xunlei.niux.easyutils.sign.SignUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileGuildBoImpl
implements MobileGuildBo {
    private static final Logger logger = Logger.getLogger((String)MobileGuildBoImpl.class.getName());
    private static final String downloadurl = "http://preloaddown.boxsvr.niu.xunlei.com/webgame/";
    private static final String callbackurl = "http://dy.niu.xunlei.com/guild/speadCallBack.do";
    private static final String apkPath = "/usr/local/htdocs/xlniuxcentersvr2/pack.sh";
    @Autowired
    private MobileGuildDao mobileGuildDao;
    private static Random random = MobileGuildBoImpl.getRandom();

    @Override
    public List<GuildGameDto> getGuildGames(long userId) {
        return this.mobileGuildDao.getGuildGames(userId);
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildSpread(long uid, String seqIds, int pageIndex, int pageSize) {
        return this.mobileGuildDao.getGuildSpread(uid, seqIds, pageIndex, pageSize);
    }

    @Override
    public int countGuildSpread(long uid, String seqIds) {
        return this.mobileGuildDao.countGuildSpread(uid, seqIds);
    }

    @Override
    public void addPackageSpead(long uid, String gameIds) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("agentId", uid + "");
        params.put("bizNo", "000001");
        String sign = SignUtil.sign(params, (String)"B1kRlQWSoPCIM8xm");
        String urlnb = "http://basenb.niu.xunlei.com/currency/replace/queryagentbyid.do?resptype=plain&agentId=" + uid + "&bizNo=000001&sign=" + sign;
        logger.info((Object)("/addPackageSpead queryagentbyid.do url=" + urlnb));
        String ret = HttpClientUtil.get((String)urlnb);
        logger.info((Object)("/addPackageSpead queryagentbyid.do ret=" + ret));
        JSONObject jsonObject = null;
        jsonObject = new JSONObject(ret);
        int code = jsonObject.getInt("rtn");
        JSONObject data = jsonObject.getJSONObject("data");
        String channelId = null;
        if (code != 0) {
            throw new XLRuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String isGuild = data.getString("isGuild");
        channelId = data.getString("advNo");
        if (!"true".equals(isGuild) || StringUtils.isEmpty((String)channelId)) {
            throw new XLRuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String gameIdsDot = this.getDotStr(gameIds);
        List<MobileGameApkDto> apks = FacadeFactory.INSTANCE.getMobileGuildBo().getGameApk(gameIdsDot);
        HashMap<String, MobileGameApkDto> apkMap = new HashMap<String, MobileGameApkDto>();
        for (MobileGameApkDto mobileGameApkDto : apks) {
            apkMap.put(mobileGameApkDto.getGameId(), mobileGameApkDto);
        }
        MobileGuildSpread mobileGuildSpread_query = new MobileGuildSpread();
        mobileGuildSpread_query.setGuildUserId(uid);
        List<MobileGuildSpread> speadList = this.mobileGuildDao.getPackagedSpreads(null, null, uid + "");
        HashMap<String, MobileGuildSpread> spreadMap = new HashMap<String, MobileGuildSpread>();
        String[] games = gameIds.split(",");
        for (MobileGuildSpread mobileGuildSpread : speadList) {
            spreadMap.put(mobileGuildSpread.getGameId(), mobileGuildSpread);
            boolean flag = false;
            for (String gameId : games) {
                if (!gameId.equals(mobileGuildSpread.getGameId())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            mobileGuildSpread.setHasChecked(false);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
            logger.info((Object)("packageSpead HasChecked false gameId=" + mobileGuildSpread.getGameId() + " userid=" + uid));
        }
        ArrayList<String> packageList = new ArrayList<String>();
        for (String gameId : games) {
            MobileGameApkDto mobileGameApkDto = (MobileGameApkDto)apkMap.get(gameId);
            if (null == mobileGameApkDto) continue;
            String nowApkVersion = this.getVersion(mobileGameApkDto.getApkName());
            MobileGuildSpread mobileGuildSpread = (MobileGuildSpread)spreadMap.get(gameId);
            if (null == mobileGuildSpread || !mobileGuildSpread.getAppVersion().equals(nowApkVersion) || !mobileGuildSpread.getHasFinished()) {
                packageList.add(gameId);
                continue;
            }
            mobileGuildSpread.setHasChecked(true);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
            logger.info((Object)("packageSpead HasChecked true gameId=" + mobileGuildSpread.getGameId() + " userid=" + uid));
        }
        SimpleDateFormat sft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowStr = sft.format(new Date());
        StringBuffer gameNosb = new StringBuffer();
        StringBuffer apkNamesb = new StringBuffer();
        StringBuffer loginKeysb = new StringBuffer();
        StringBuffer seqIdsb = new StringBuffer();
        for (String gameId : packageList) {
            MobileGuildSpread mobileGuildSpread = (MobileGuildSpread)spreadMap.get(gameId);
            MobileGameApkDto mobileGameApkDto = (MobileGameApkDto)apkMap.get(gameId);
            MobileGuildSpread spread = null;
            String guiidApkName = this.getGuiidApkName(mobileGameApkDto.getApkName(), channelId);
            String url = downloadurl + mobileGameApkDto.getGameNo() + "/" + guiidApkName;
            MobileGuildSpread mobileGuildSpread_db = null;
            if (null == mobileGuildSpread) {
                spread = new MobileGuildSpread();
                spread.setAppVersion(this.getVersion(mobileGameApkDto.getApkName()));
                spread.setGameId(gameId);
                spread.setAppSize(mobileGameApkDto.getAppSize());
                spread.setDownloadUrl(url);
                spread.setGuildUserId(uid);
                spread.setPlatform("\u5b89\u5353");
                spread.setChannelId(channelId);
                spread.setApkId(mobileGameApkDto.getApkId());
                spread.setHasFinished(false);
                spread.setHasChecked(true);
                spread.setInputTime(nowStr);
                spread = this.changeShortUrl(spread, channelId);
                FacadeFactory.INSTANCE.getBaseSo().addObject(spread);
            } else {
                spread = mobileGuildSpread;
                spread.setAppVersion(this.getVersion(mobileGameApkDto.getApkName()));
                spread.setAppSize(mobileGameApkDto.getAppSize());
                spread.setHasChecked(true);
                spread.setDownloadUrl(url);
                spread.setInputTime(nowStr);
                spread = this.changeShortUrl(spread, channelId);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(spread);
            }
            mobileGuildSpread_db = FacadeFactory.INSTANCE.getBaseSo().findObject(spread);
            loginKeysb.append(this.getLoginKey(mobileGameApkDto.getGameId())).append(",");
            gameNosb.append(mobileGameApkDto.getGameNo()).append(",");
            String apkName = mobileGameApkDto.getApkName().replace(".apk", "");
            apkNamesb.append(apkName).append(",");
            if (null == mobileGuildSpread_db) continue;
            seqIdsb.append(mobileGuildSpread_db.getSeqId()).append(",");
        }
        String gameNos = this.subDotStr(gameNosb.toString());
        String apkNames = this.subDotStr(apkNamesb.toString());
        String loginKeys = this.subDotStr(loginKeysb.toString());
        String seqIds = this.subDotStr(seqIdsb.toString());
        String callBack = "http://dy.niu.xunlei.com/guild/speadCallBack.do?seqIds=" + seqIds;
        this.packageSpead(callBack, channelId, gameNos, apkNames, loginKeys);
    }

    private String getVersion(String apkName) {
        String[] arr = (apkName = apkName.replace(".apk", "")).split("_");
        if (arr.length > 1) {
            return arr[1];
        }
        return "";
    }

    public static synchronized String createAdvNo() {
        String orderId = MobileGuildBoImpl.createAdvNo(random);
        return orderId;
    }

    private static String createAdvNo(Random random) {
        double r = random.nextDouble();
        String s = new Double(r).toString().substring(3, 13);
        String orderId = new SimpleDateFormat("yyyyMMdd").format(new Date());
        orderId = orderId + s;
        return orderId;
    }

    private static Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                long now = DatetimeUtil.parseTimeByYYYYMMDDHHMMSS((String)DatetimeUtil.now());
                random.setSeed(now);
            }
        }, 0L, 3600000L);
        return random;
    }

    private void deleteInfos(String gameId, String channelId, String shortUrl) {
        CommonSpreadInfo query = new CommonSpreadInfo();
        query.setAdvNo(channelId);
        query.setGameId(gameId);
        query.setShortUrl(shortUrl);
        List<CommonSpreadInfo> infos = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (CommonSpreadInfo info : infos) {
            FacadeFactory.INSTANCE.getBaseSo().deleteById(CommonSpreadInfo.class, info.getSeqId());
        }
    }

    private MobileGuildSpread changeShortUrl(MobileGuildSpread mobileGuildSpread, String channelId) {
        String shortUrl = "http://jump2.niu.xunlei.com:8080/" + mobileGuildSpread.getGameId() + "/" + channelId;
        this.deleteInfos(mobileGuildSpread.getGameId(), channelId, shortUrl);
        CommonSpreadInfo csi = new CommonSpreadInfo();
        csi.setAdvNo(channelId);
        csi.setJumpType(1);
        csi.setGameId(mobileGuildSpread.getGameId());
        String jumpAdvNo = MobileGuildBoImpl.createAdvNo();
        csi.setJumpAdvNo(jumpAdvNo);
        csi.setShortUrl(shortUrl);
        csi.setJumpUrl(mobileGuildSpread.getDownloadUrl());
        csi.setMuliPhotoUrl("");
        csi.setVersion(mobileGuildSpread.getAppVersion());
        csi.setIsValid(true);
        csi.setRecordTime(DateUtil.formatNowByDefault());
        FacadeFactory.INSTANCE.getBaseSo().addObject(csi);
        mobileGuildSpread.setDownloadUrl(csi.getShortUrl());
        return mobileGuildSpread;
    }

    private List<MobileGuildSpread> getPackagedSpreadsDb(List<MobileGuildSpread> dataList) {
        StringBuffer apkIdsStr = new StringBuffer();
        StringBuffer gameidsStr = new StringBuffer();
        StringBuffer uidsStr = new StringBuffer();
        for (MobileGuildSpread mobileGuildSpread : dataList) {
            apkIdsStr.append(mobileGuildSpread.getApkId()).append(",");
            gameidsStr.append("'" + mobileGuildSpread.getGameId() + "'").append(",");
            uidsStr.append(mobileGuildSpread.getGuildUserId()).append(",");
        }
        String apkIds = this.subDotStr(apkIdsStr.toString());
        String gameids = this.subDotStr(gameidsStr.toString());
        String uids = this.subDotStr(uidsStr.toString());
        return this.mobileGuildDao.getPackagedSpreads(apkIds, gameids, uids);
    }

    private void packageSpead(String callBackUrl, String chanelId, String gameNos, String apkNames, String loginKeys) {
        try {
            Runtime.getRuntime().exec("/usr/local/htdocs/xlniuxcentersvr2/pack.sh  " + callBackUrl + "  " + chanelId + "  " + gameNos + "  " + apkNames + "  " + loginKeys);
            logger.info((Object)("packageGuildSpead success callBackUrl=" + callBackUrl + ",chanelId=" + chanelId + ",gameNos=" + gameNos + ",apkNames=" + apkNames + ",loginKeys=" + loginKeys));
        }
        catch (IOException e) {
            logger.error((Object)("packageGuildSpead IOException callBackUrl=" + callBackUrl + ",chanelId=" + chanelId + ",gameNos=" + gameNos + ",apkNames=" + apkNames + ",loginKeys=" + loginKeys));
            e.printStackTrace();
        }
    }

    @Override
    public void updateSpead(String seqIds) {
        List<MobileGuildSpread> list = FacadeFactory.INSTANCE.getMobileGuildBo().getGuildSpread(0L, seqIds);
        for (MobileGuildSpread mobileGuildSpread : list) {
            if (mobileGuildSpread.getHasFinished()) continue;
            mobileGuildSpread.setHasFinished(true);
            mobileGuildSpread.setHasChecked(true);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mobileGuildSpread);
        }
    }

    @Override
    public List<MobileGuildSpread> getGuildSpread(long uid, String seqIds) {
        return this.mobileGuildDao.getGuildSpread(uid, seqIds);
    }

    @Override
    public List<MobileGuildSpreadDTO> getGuildInfo(String gameIds) {
        return this.mobileGuildDao.getGuildGameInfo(gameIds);
    }

    @Override
    public List<MobileGameApkDto> getGameApk(String gameIds) {
        return this.mobileGuildDao.getGameApk(gameIds);
    }

    private MobileGuildSpread bulidMobileGuildSpread(MobileGuildSpreadDTO mobileGuildSpreadDTO, long uid, String url, MobileGuildUser user) {
        MobileGuildSpread spread = new MobileGuildSpread();
        spread.setAppVersion(mobileGuildSpreadDTO.getAppVersion());
        spread.setGameId(mobileGuildSpreadDTO.getGameId());
        spread.setAppSize(mobileGuildSpreadDTO.getAppSize());
        spread.setDownloadUrl(url);
        spread.setGuildUserId(uid);
        spread.setPlatform("\u5b89\u5353");
        spread.setChannelId(user.getChanelId());
        spread.setApkId(mobileGuildSpreadDTO.getApkId());
        spread.setHasFinished(false);
        return spread;
    }

    private String getLoginKey(String gameid) {
        GameXmlMeta query = new GameXmlMeta();
        query.setNewgameid(gameid);
        GameXmlMeta meta = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if (meta == null) {
            return null;
        }
        return meta.getLoginKey();
    }

    private String getGuiidApkName(String apkName, String chanelId) {
        String pathName = null;
        apkName = apkName.replace(".apk", "");
        pathName = apkName + "_" + chanelId + ".apk";
        return pathName;
    }

    public String getDotStr(String strs) {
        strs = strs.replace("\uff0c", ",");
        String[] spells = strs.split(",");
        StringBuffer sb = new StringBuffer();
        for (String str : spells) {
            if (!StringUtils.isNotEmpty((String)str)) continue;
            sb.append("'" + str + "',");
        }
        strs = sb.toString();
        if (strs.endsWith(",")) {
            strs = strs.substring(0, strs.length() - 1);
        }
        return strs;
    }

    public String subDotStr(String str) {
        if (StringUtils.isNotEmpty((String)str) && str.endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

