/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JRedisProxy {
    private static JRedisProxy jRedisProxy = new JRedisProxy();
    private static Logger logger = Logger.getLogger((String)"redisLoger");
    private Properties config = new Properties();
    private JedisPool pool;

    public static JRedisProxy getInstance() {
        return jRedisProxy;
    }

    private JRedisProxy() {
        try {
            System.out.println("jredis system\u8fde\u63a5 \u521d\u59cb\u5316");
            this.config.load(JRedisProxy.class.getClassLoader().getResourceAsStream("jredis.properties"));
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxActive(Integer.parseInt(this.config.getProperty("maxActive", "1000")));
            poolConfig.setMaxIdle(Integer.parseInt(this.config.getProperty("maxIdle", "30")));
            poolConfig.setMaxWait((long)Integer.parseInt(this.config.getProperty("maxWait", "1000")));
            poolConfig.setTestOnBorrow(false);
            poolConfig.setTestOnReturn(false);
            this.pool = new JedisPool((GenericObjectPool.Config)poolConfig, this.config.getProperty("host"), Integer.parseInt(this.config.getProperty("port", "6379")));
        }
        catch (Exception e) {
            System.out.println("jredis system\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u5931\u8d25");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value, int seconds) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.setex(key, seconds, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info((Object)("jredisSet\u5f02\u5e38\uff1akey=" + key + ",value=" + value + ",seconds=" + seconds), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.set(key, value);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.info((Object)("jredisSet\u5f02\u5e38\uff1akey=" + key + ",value=" + value), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        String value = null;
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            value = jedis.get(key);
        }
        catch (Exception e) {
            logger.info((Object)("jredisget\u5f02\u5e38\uff1akey=" + key + ",value=" + value), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            jedis.del(new String[]{key});
        }
        catch (Exception e) {
            logger.info((Object)("jredisdel\u5f02\u5e38\uff1akey=" + key), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delByPrefix(String prefix) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            Set keys = jedis.keys(prefix + "*");
            for (String key : keys) {
                jedis.del(new String[]{key});
            }
        }
        catch (Exception e) {
            logger.error((Object)("jredisdel\u5f02\u5e38\uff1aprefix=" + prefix), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.pool.getResource();
            long ttl = jedis.ttl(key);
            if (ttl > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.info((Object)("jredisEsists\u5f02\u5e38\uff1akey=" + key), (Throwable)e);
        }
        finally {
            if (jedis != null) {
                this.pool.returnBrokenResource((Object)jedis);
            }
        }
        return false;
    }

    public void test() {
        try {
            Jedis jedis = (Jedis)this.pool.getResource();
            if (this.exists("000120_1_ROLE_FIGHT")) {
                System.out.println(true);
            }
            this.pool.returnBrokenResource((Object)jedis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JRedisProxy.getInstance().test();
    }

    public byte[] serialize(List<Object> list) throws Exception {
        if (list == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            for (Object obj : list) {
                os.writeObject(obj);
            }
            os.writeObject(null);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (bos != null) {
                    bos.close();
                    bos = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rv;
    }

    public List<Object> deserialize(byte[] in) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                Object user;
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                while ((user = is.readObject()) != null) {
                    list.add(user);
                }
                is.close();
                bis.close();
            }
        }
        catch (IOException e) {
            throw new Exception("Caught CNFE decoding %d bytes of data");
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Caught CNFE decoding %d bytes of data");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (bis != null) {
                    bis.close();
                    bis = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

