package com.xunlei.niux.data.vipgame.dao.niutip;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.dao.BaseDao;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.niux.data.vipgame.dto.NiuTipConditionDTO;
import com.xunlei.niux.data.vipgame.vo.niutip.NiuTipConditions;
import com.xunlei.niux.data.vipgame.vo.niutip.NiuTips;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by xl on 2016/8/9.
 */
public class NiuTipsDaoImpl  extends BaseDaoImpl implements NiuTipsDao {


    @Override
    public List<LibClassD> getNotInLibClassD(List<LibClassD> libClassDs, Long tipId) {
        String sql = "select * from niutipconditions where tipId = ? ";
        List<Object> param = new ArrayList();
        param.add(tipId);
        List<NiuTipConditions> inConditons = findBySql(NiuTipConditions.class, sql, param);
        Map<String,LibClassD>  map = new HashMap<String, LibClassD>(libClassDs.size());
        if(inConditons.size()>0){
            for(LibClassD d : libClassDs){
                map.put(d.getItemno(),d);
            }
            for(NiuTipConditions condition : inConditons){
                libClassDs.remove(map.get(condition.getConditionId()));
            }
        }

        return libClassDs;
    }

    @Override
    public void removeConditions(Long [] conditionIds, Long tipId) {
        String sql = "delete from niutipconditions where tipId = ? and seqId in (?)";
        String conditionIdStrs = "";
        for(Long id : conditionIds){
            conditionIdStrs +=id+",";
        }
        conditionIdStrs = conditionIdStrs.substring(0,conditionIdStrs.length()-1);
        List<Object> list = new ArrayList<Object>();
        list.add(tipId);
        list.add(conditionIdStrs);
        execute(sql,list);
    }

    @Override
    public void addConditions(String [] conditionIds, Long tipId) {
        for(String id : conditionIds){
            NiuTipConditions condition = new NiuTipConditions();
            condition.setTipId(tipId);
            condition.setConditionId(id);
            insert(condition);
        }
    }

    @Override
    public List<NiuTips> getEffectNiuTips(String dateTime) {
        String sql = "select * from niutips where startTime <= ? and endTime >= ? ";
        List<Object> param = new ArrayList<Object>();
        param.add(dateTime);
        param.add(dateTime);
        return findBySql(NiuTips.class,sql,param);
    }

    @Override
    public List<NiuTipConditions> getAllNiuTipConditon(String tipIds) {
        String sql = "select * from niutipconditions where tipId in ("+tipIds+")";
        return findBySql(NiuTipConditions.class,sql,new ArrayList<Object>());
    }

    @Override
    public List<NiuTips> getEffectNiuTipByClientType(String dateTime, String clientType) {

        String sql = "select * from niutips where startTime <= ? and endTime >= ? and displayPage = ?  order by orderNo desc ";
        List<Object> param = new ArrayList<Object>();
        param.add(dateTime);
        param.add(dateTime);
        param.add(clientType);
        List<NiuTips> niuTipses = findBySql(NiuTips.class, sql, param);
        return niuTipses;
    }

    @Override
    public int getTipRecordCount(NiuTips niuTips, Long userId,String displayPage) {
        String sql = "select count(*) from niutiprecords where userid = ? and displayPage = ? and recordTime >= DATE_ADD(CURRENT_DATE(),INTERVAL ? DAY)";
        Object [] objects = new Object[]{userId,"-"+niuTips.getTriggerCycle(),displayPage};
        return getJdbcTemplate().queryForInt(sql,objects);
    }
}
