package com.xunlei.niux.data.vipgame.bo.activity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.vo.activity.Coupon;
/**
 * 优惠券
 * @author 林志军
 */
@Service()
public class CouponBoImpl implements CouponBo {
    protected static SimpleDateFormat sdf_time=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public Coupon giveOutCoupon(String couponType,int couponValue,String userId,String actNo,String userOrderNo){
		if(StringUtils.isEmpty(couponType)||couponValue <= 0){
			throw new RuntimeException("coupon type or value is null");
		}
		String sql="select * from coupon where couponStatus='1' and couponType=? and couponValue=?   limit 1 for update";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(couponType);
		paramList.add(couponValue);
		
		List<Coupon> coupons=baseDao.executeQuery(Coupon.class, sql, paramList);//baseDao.findBySql(Coupon.class, sql);
		if(coupons.size()==0){
			throw new RuntimeException("没有激活码");
		}
		Coupon newCoupon=coupons.get(0);
		newCoupon.setCouponStatus(2);
		newCoupon.setUserId(userId);
		newCoupon.setUseActNo(actNo);
		newCoupon.setUseTime(sdf_time.format(new Date()));
		newCoupon.setUseOrderNo(userOrderNo);
		
		baseDao.updateById(newCoupon);
        return newCoupon;
	}
}
