package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.GameInsideplaceDao;
import com.xunlei.niux.data.vipgame.vo.GameInsideplace;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
public class GameInsideplaceBoImpl implements GameInsideplaceBo {

    private GameInsideplaceDao baseDao;

    public GameInsideplaceDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(GameInsideplaceDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<GameInsideplace> find(GameInsideplace gameInsideplace, int start, int limit) {
        Page page = new Page();
        page.setPageNo(start);
        page.setPageSize(limit);
        page.addOrder("displayOrder", OrderType.ESC);

        return baseDao.findByObject(GameInsideplace.class, gameInsideplace, page);
    }

    @Override
    public GameInsideplace findById(long seqid) {
        return baseDao.findById(GameInsideplace.class, seqid);
    }

    @Override
    public void insert(GameInsideplace gameInsideplace) {
        String titlePid = gameInsideplace.getTitlepid();
        Map<String, String> ids =  baseDao.getMaxId(titlePid, gameInsideplace.getGameid());

        String titleid = getId(titlePid, ids.get("titleid"));
        gameInsideplace.setTitleid(titleid);

        String pOrder = baseDao.getOrderIdByTitleId(titlePid, gameInsideplace.getGameid());
        if(pOrder == null) {
            pOrder = "0";
        }
        String order = getId(pOrder, ids.get("displayOrder"));
        gameInsideplace.setDisplayOrder(order);

        baseDao.insert(gameInsideplace);
    }

    private String getId(String pid, String maxId) {
        if (maxId == null) {
            //初始ID
            if("0".equals(pid)) {
                return "001";
            } else {
                return pid + "001";
            }
        } else {
            return TitleId.getNextId(maxId);
        }
    }

    @Override
    public void update(GameInsideplace gameInsideplace) {
        baseDao.updateById(gameInsideplace);
    }

    @Override
    public int count(GameInsideplace gameInsideplace) {
        return baseDao.count(gameInsideplace);
    }

    @Override
    public void delete(long seqid) {
        baseDao.deleteById(GameInsideplace.class, seqid);
    }

    @Override
    public boolean exchangeOrder(long seqid, String way) {
        return baseDao.exchangeOrder(seqid, way);
    }


    public static enum TitleId {

        ZERO(0, 3),
        FIRST(3, 6),
        SECOND(6, 9);

        private TitleId(int preLength, int length) {
            this.preLength = preLength;
            this.length = length;
        }

        //上一级长度
        private int preLength;

        //总共长度
        private int length;

        public static String getNextId(String id) {
            TitleId titleId = valueOfId(id);

            if(titleId == null) {
                throw new IllegalArgumentException("不是有效的标题ID：" + id);
            }

            String preId;
            String next;
            if(titleId.preLength != 0) {
                preId = id.substring(0, titleId.preLength);
                next = id.substring(titleId.preLength);
            } else {
                preId = "";
                next = id;
            }


            int nextLength = titleId.length - titleId.preLength;

            try {
                next = preId + format(nextLength, parse(next) + 1);
            } catch (ParseException e) {
                throw new IllegalArgumentException("不是有效的标题ID：" + id, e);
            }

            return next;
        }


        private static TitleId valueOfId(String id) {
            int idLength = id.length();

            TitleId tempId = null;
            for(TitleId titleId : values()) {
                if(titleId.length == idLength) {
                    tempId = titleId;
                    break;
                }
            }

            return tempId;
        }

        private static String format(int length, int num) {
            String pattern = "";

            while (length-- > 0) {
                pattern += "0";
            }

            DecimalFormat df = new DecimalFormat(pattern);
            return df.format(num);
        }

        private static int parse(String str) throws ParseException {
            String pattern = "";

            int length = str.length();
            while (length-- > 0) {
                pattern += "0";
            }

            DecimalFormat df = new DecimalFormat(pattern);
            return df.parse(str).intValue();
        }

    }
}
