package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.CustomerBigPayQuery;

public class CustomerBigPayQueryBoImpl extends BaseDaoImpl implements CustomerBigPayQueryBo {

	private BaseDao baseDao;
	
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	
	public int queryForInt(String sql,Object args[]){
		return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public int count(CustomerBigPayQuery customer) {
		return baseDao.count(customer);
	}


	public List<CustomerBigPayQuery> find(CustomerBigPayQuery customer,String sql,Page page){
		Select select = new Select(customer, page);
		String presql = select.getPreSql();		
		if(presql.indexOf("order by")>-1){
			String strs[] = presql.split("order by");
			if(strs[0].indexOf("where")==-1){//如果查询条件中不包含where
				strs[0] += " where 1=1 ";
			}
	        sql =  strs[0]+sql+" order by "+strs[1];
		}else{
			if(presql.indexOf("where")==-1){//如果查询条件中不包含where
				presql += " where 1=1 ";
			}
	        sql =  presql+sql;
		}
		return findBySql(CustomerBigPayQuery.class,sql, select.getParamsList());
	}

	public int count(String sql,Object [] args){
	    return getJdbcTemplate().queryForInt(sql, args);
	}
	
	@Override
	public List<CustomerBigPayQuery> find(
			CustomerBigPayQuery customer, Page page) {
		return baseDao.findByObject(CustomerBigPayQuery.class, customer, page);
	}

	@Override
	public CustomerBigPayQuery findById(long id) {
		return baseDao.findById(CustomerBigPayQuery.class, id);
	}

	@Override
	public void insert(CustomerBigPayQuery customer) {
		baseDao.insert(customer);
	}

	@Override
	public void update(CustomerBigPayQuery customer) {
		baseDao.updateById(customer);
	}
	
	public List findBySql(Class clazz, String preSql, List paramList){
		 return baseDao.findBySql(clazz, preSql, paramList);
	}

}
