package com.xunlei.niux.data.vipgame.vo.report;

import java.io.Serializable;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;

/**
 * @author admin
 * 
 */
@Table(tableName = "report_v2", pkFieldName = "seqId", pkFieldAssign = false)
public class ReportInfoV2 implements Serializable {
	
	private static final long serialVersionUID = 8625359382848757867L;
	
	private Integer seqId;
	private String gameId;
	private String serverId;
	
	/** 渠道类型。1: QQ 2：YY */
	private Integer channelType;
	/** 渠道 */
	private String channel;
	/** 游戏内截图 */
	private String gameScreenshot;
	/** QQ截图或YY截图 */
	private String channelScreenshot;
	/** 拉人服务器截图 */
	private String serverScreenshot;
	/** 举报者 */
	private String user;
	/** 举报者IP */
	private String ip;
	/** 备注 */
	private String remark;
	
	/** 举报时间 */
	private String reportTime;
	
	@Column(columnName = "reportTime", isWhereColumn = true, operator = Operator.GE)
	private String fromReportTime;
	@Column(columnName = "reportTime", isWhereColumn = true, operator = Operator.LT)
	private String toReportTime;
	
	/** 奖励时间 */
	private String rewardTime;
	
	@Column(columnName = "rewardTime", isWhereColumn = true, operator = Operator.GE)
	private String fromRewardTime;
	@Column(columnName = "rewardTime", isWhereColumn = true, operator = Operator.LT)
	private String toRewardTime;
	
	/** 奖励类型。1：激活码 */
	private Integer rewardType;
	/** 奖励 */
	private String reward;

	public Integer getSeqId() {
		return seqId;
	}

	public void setSeqId(Integer seqId) {
		this.seqId = seqId;
	}

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

	public String getServerId() {
		return serverId;
	}

	public void setServerId(String serverId) {
		this.serverId = serverId;
	}

	public String getChannel() {
		return channel;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getGameScreenshot() {
		return gameScreenshot;
	}

	public void setGameScreenshot(String gameScreenshot) {
		this.gameScreenshot = gameScreenshot;
	}

	public String getChannelScreenshot() {
		return channelScreenshot;
	}

	public void setChannelScreenshot(String channelScreenshot) {
		this.channelScreenshot = channelScreenshot;
	}

	public String getServerScreenshot() {
		return serverScreenshot;
	}

	public void setServerScreenshot(String serverScreenshot) {
		this.serverScreenshot = serverScreenshot;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getReportTime() {
		return reportTime;
	}

	public void setReportTime(String reportTime) {
		this.reportTime = reportTime;
	}

	public String getRewardTime() {
		return rewardTime;
	}

	public void setRewardTime(String rewardTime) {
		this.rewardTime = rewardTime;
	}

	public String getFromReportTime() {
		return fromReportTime;
	}

	public void setFromReportTime(String fromReportTime) {
		this.fromReportTime = fromReportTime;
	}

	public String getToReportTime() {
		return toReportTime;
	}

	public void setToReportTime(String toReportTime) {
		this.toReportTime = toReportTime;
	}

	public Integer getRewardType() {
		return rewardType;
	}

	public void setRewardType(Integer rewardType) {
		this.rewardType = rewardType;
	}

	public String getReward() {
		return reward;
	}

	public void setReward(String reward) {
		this.reward = reward;
	}

	public String getFromRewardTime() {
		return fromRewardTime;
	}

	public void setFromRewardTime(String fromRewardTime) {
		this.fromRewardTime = fromRewardTime;
	}

	public String getToRewardTime() {
		return toRewardTime;
	}

	public void setToRewardTime(String toRewardTime) {
		this.toRewardTime = toRewardTime;
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ReportInfoV2 [seqId=").append(seqId)
				.append(", gameId=").append(gameId).append(", serverId=")
				.append(serverId).append(", channelType=").append(channelType)
				.append(", channel=").append(channel)
				.append(", gameScreenshot=").append(gameScreenshot)
				.append(", channelScreenshot=").append(channelScreenshot)
				.append(", serverScreenshot=").append(serverScreenshot)
				.append(", user=").append(user).append(", ip=").append(ip)
				.append(", remark=").append(remark).append(", reportTime=")
				.append(reportTime).append(", fromReportTime=")
				.append(fromReportTime).append(", toReportTime=")
				.append(toReportTime).append(", rewardTime=")
				.append(rewardTime).append(", fromRewardTime=")
				.append(fromRewardTime).append(", toRewardTime=")
				.append(toRewardTime).append(", rewardType=")
				.append(rewardType).append(", reward=").append(reward)
				.append("]");
		return builder.toString();
	}

}
