package com.xunlei.niux.data.vipgame.bo.bonus;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductGiveOutDayStatistics;
@Service
public class BonusProductGiveOutDayStatisticsBoImpl implements
		BonusProductGiveOutDayStatisticsBo {
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	/**
	 * 
	 * @param productNo
	 * @param giveOutDate
	 */
	public BonusProductGiveOutDayStatistics update_addOne(String productNo,String giveOutDate){
		BonusProductGiveOutDayStatistics bpgods=find(productNo,giveOutDate);
		if(bpgods==null){
			bpgods=new BonusProductGiveOutDayStatistics();
			bpgods.setGiveOutDate(giveOutDate);
			bpgods.setProductNo(productNo);
			bpgods.setGiveOutSum(1);
			baseDao.insert(bpgods);
		}else{
			bpgods.setGiveOutSum(bpgods.getGiveOutSum()+1);
			baseDao.updateById(bpgods);
		}
		return bpgods;
	}
	public BonusProductGiveOutDayStatistics update_removeOne(String productNo,String giveOutDate){
		BonusProductGiveOutDayStatistics bpgods=find(productNo,giveOutDate);
		if(bpgods==null){
			throw new RuntimeException("日统计不存在");
		}
		bpgods.setGiveOutSum(bpgods.getGiveOutSum()-1);
		baseDao.updateById(bpgods);
		return bpgods;
	}
	public BonusProductGiveOutDayStatistics find(String productNo,String giveOutDate){
		if(productNo==null||"".equals(productNo)){
			throw new RuntimeException("产品编号为空");
		}
		if(giveOutDate==null||"".equals(giveOutDate)){
			throw new RuntimeException("发放时间为空");
		}
		BonusProductGiveOutDayStatistics bpgods=new BonusProductGiveOutDayStatistics();
		bpgods.setProductNo(productNo);
		bpgods.setGiveOutDate(giveOutDate);
		List<BonusProductGiveOutDayStatistics> list=find(bpgods,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<BonusProductGiveOutDayStatistics> find(BonusProductGiveOutDayStatistics bpgods,Page page){
		return baseDao.findByObject(BonusProductGiveOutDayStatistics.class, bpgods, page);
	}
}
