package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dto.CheatingReportDTO;
import com.xunlei.niux.data.vipgame.vo.CheatingReport;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/1/13.
 */
public class CheatingReportDaoImpl extends BaseDaoImpl implements CheatingReportDao {

    @Override
    public List<CheatingReport> getQueryCheatingReportDTO(CheatingReportDTO dto, Page page) {
        Select select = new Select(dto,page);
        String sql ="select * from cheating_report where 1=1 "+getParams(dto) +select.createOrder(dto,page)+select.createLimit(page);

        final List<CheatingReportDTO> list = new ArrayList<CheatingReportDTO>();
        List<CheatingReport> cheatingReportDTOs = executeQuery(CheatingReport.class, sql, new ArrayList<Object>());

        return cheatingReportDTOs;
    }

    @Override
    public List<CheatingReport> getQueryCheatingReportDTO(CheatingReportDTO dto) {
        String sql ="select * from cheating_report where 1=1 "+getParams(dto)+" order by reportTime desc ";

        final List<CheatingReportDTO> list = new ArrayList<CheatingReportDTO>();
        List<CheatingReport> cheatingReportDTOs = executeQuery(CheatingReport.class, sql, new ArrayList<Object>());

        return cheatingReportDTOs;
    }

    @Override
    public int countCheatingReportDTO(CheatingReportDTO dto) {
        String sql ="select COUNT(*) from cheating_report where 1=1 "+getParams(dto);
        return this.getJdbcTemplate().queryForInt(sql, new Object[]{});
    }



    private String getParams(CheatingReportDTO dto){
        if(null==dto){
            return "";
        }
        StringBuilder params = new StringBuilder();

        if(StringUtils.isNotEmpty(dto.getStartTime())){
            params.append(" and reportTime >='"+dto.getStartTime()+"' ");
        }

        if(StringUtils.isNotEmpty(dto.getEndTime())){
            params.append(" and reportTime <='"+dto.getEndTime()+"' ");
        }

        if(StringUtils.isNotEmpty(dto.getCheaterGameId())){
            params.append(" and cheaterGameId='"+dto.getCheaterGameId()+"' ");
        }

        if(StringUtils.isNotEmpty(dto.getCheaterServerId())){
            params.append(" and cheaterServerId='"+dto.getCheaterServerId()+"' ");
        }

        if(dto.getStatus()!=null&&dto.getStatus()!=0) {
            params.append(" and status='"+dto.getStatus()+"' ");
        }

        return params.toString();
    }
}
