package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.GuildGameDto;
import com.xunlei.niux.data.vipgame.dto.MoblieGameOrderDto;
import com.xunlei.niux.data.vipgame.dto.WelfareDto;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/5/20.
 */
public class MobileWelfareDaoImpl extends BaseDaoImpl implements MobileWelfareDao{

    public List<WelfareDto> getNewGift(LinkInfo linkInfo){
        StringBuilder sql=new StringBuilder();
        sql.append(" SELECT t.gameid,t.linktitle,g.picUrl,g.smallPicUrl,t.displaysort,g.gameName,t.ext6 from linkinfo t  ");
        sql.append(" LEFT JOIN games g on t.gameid=g.gameId  where t.linklocid='1592' and t.isvalid=1  and t.istest=0 ");
        List<Object> args=new ArrayList<Object>();
        if(StringUtils.isNotEmpty(linkInfo.getFromvaliddatetime())){
            sql.append(" and t.validdatetime>=?");
            args.add(linkInfo.getFromvaliddatetime());
        }
        if(StringUtils.isNotEmpty(linkInfo.getTovaliddatetime())){
            sql.append(" and t.validdatetime<=?");
            args.add(linkInfo.getTovaliddatetime());
        }

        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(WelfareDto.class));
    }

    public List<MoblieGameOrderDto> getMyOrders(long uid){
        StringBuilder sql=new StringBuilder();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.gameId,g.gameName,g.gameDesc,g.picUrl.g.smallPicUrl,g.packageName,l.ext5 ");
        sql.append(" from mobilegame_order_record t ");
        sql.append(" left join linkinfo l on t.gameId=l.gameidbytuijian and l.linklocid='863' ");
        sql.append(" LEFT JOIN games g on t.gameId=g.gameId ");
        if(uid!=0){
            sql.append(" where t.userId = ?");
            args.add(uid);
        }
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(MoblieGameOrderDto.class));
    }

}
