/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.activity;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.activity.VirtualCardBo;
import com.xunlei.niux.data.vipgame.proxy.JRedisProxy;
import com.xunlei.niux.data.vipgame.vo.activity.VirtualCard;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class VirtualCardBoImpl
implements VirtualCardBo {
    private static Logger logger = Logger.getLogger(VirtualCardBoImpl.class);
    protected static SimpleDateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int day = 1;
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public VirtualCard giveOut(String type, String userId, String orderId, String orderActNo, String ip) {
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orderId)) {
            return null;
        }
        String sql = "select * from virtualcard where orderId = ? limit 1";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(orderId);
        List virtualCards = this.baseDao.executeQuery(VirtualCard.class, sql, paramList);
        if (virtualCards != null && virtualCards.size() > 0) {
            return null;
        }
        VirtualCard virtualCard = new VirtualCard();
        virtualCard.setType(type);
        virtualCard.setStatus(2);
        virtualCard.setUserId(userId);
        virtualCard.setOrderId(orderId);
        virtualCard.setOrderTime(sdf_time.format(new Date()));
        virtualCard.setOrderActNo(orderActNo);
        virtualCard.setIp(ip);
        this.baseDao.insert((Object)virtualCard);
        return virtualCard;
    }

    @Override
    public int use(String type, String userId, String actNo, String orderId) {
        List<VirtualCard> virtualCards_unused;
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)userId)) {
            return 2;
        }
        String expireTime = null;
        try {
            expireTime = JRedisProxy.getInstance().get("VirtualCard_" + userId + "_" + type);
        }
        catch (Exception e) {
            logger.warn((Object)("use error for cache reading. code=1,type=" + type + ",userId=" + userId + ",actNo=" + actNo), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)expireTime)) {
            List<VirtualCard> virtualCards = this.getUsedVirtualCard(type, userId);
            if (virtualCards != null && virtualCards.size() > 0) {
                return 1;
            }
        } else if (expireTime.compareTo(sdf_time.format(new Date())) > 0) {
            logger.warn((Object)("use error for cache conflict. code=1,type=" + type + ",userId=" + userId + ",actNo=" + actNo + ",expireTime=" + expireTime));
            return 1;
        }
        if ((virtualCards_unused = this.getUnusedVirtualCard(type, userId, orderId)) == null || virtualCards_unused.isEmpty()) {
            return 3;
        }
        VirtualCard virtualCard = virtualCards_unused.get(0);
        virtualCard.setStatus(4);
        virtualCard.setActNo(actNo);
        virtualCard.setBeginTime(sdf_time.format(new Date()));
        int cacheExpireTime = 86400;
        String endTime = sdf_time.format(new Date(System.currentTimeMillis() + (long)cacheExpireTime * 1000L));
        virtualCard.setEndTime(endTime);
        this.baseDao.updateById((Object)virtualCard);
        boolean updateCache = false;
        try {
            updateCache = JRedisProxy.getInstance().set("VirtualCard_" + userId + "_" + type, endTime, cacheExpireTime);
        }
        catch (Exception e) {
            logger.warn((Object)("use error for cache reading. code=1,type=" + type + ",userId=" + userId + ",actNo=" + actNo + ",endTime=" + endTime + ",cacheExpireTime=" + cacheExpireTime + ",updateCache=" + updateCache), (Throwable)e);
        }
        return 0;
    }

    @Override
    public boolean check(String type, String userId) {
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)userId)) {
            return false;
        }
        String expireTime = null;
        try {
            expireTime = JRedisProxy.getInstance().get("VirtualCard_" + userId + "_" + type);
        }
        catch (Exception e) {
            logger.warn((Object)("use error for cache reading. code=1,type=" + type + ",userId=" + userId), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)expireTime)) {
            List<VirtualCard> virtualCards = this.getUsedVirtualCard(type, userId);
            if (virtualCards != null && virtualCards.size() > 0) {
                return true;
            }
        } else if (expireTime.compareTo(sdf_time.format(new Date())) > 0) {
            logger.warn((Object)("use error for cache conflict. code=1,type=" + type + ",userId=" + userId + ",expireTime=" + expireTime));
            return true;
        }
        return false;
    }

    private List<VirtualCard> getUsedVirtualCard(String type, String userId) {
        String sql = "select * from virtualcard where type = ? and userId = ? and status = ? and beginTime is not null and beginTime <= ? and endTime is not null and endTime >= ? limit 1";
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(type);
        paramList.add(userId);
        paramList.add(4);
        String nowTime = sdf_time.format(new Date());
        paramList.add(nowTime);
        paramList.add(nowTime);
        List virtualCards = this.baseDao.executeQuery(VirtualCard.class, sql, paramList);
        return virtualCards;
    }

    private List<VirtualCard> getUnusedVirtualCard(String type, String userId, String orderId) {
        String sql_unused = "select * from virtualcard where type = ? and userId = ? and status = ? and (expireTime is null or expireTime >= ?)";
        ArrayList<Object> paramList_unused = new ArrayList<Object>();
        paramList_unused.add(type);
        paramList_unused.add(userId);
        paramList_unused.add(2);
        String nowTime_unused = sdf_time.format(new Date());
        paramList_unused.add(nowTime_unused);
        if (!StringUtils.isEmpty((String)orderId)) {
            sql_unused = sql_unused + " and orderId = ? ";
            paramList_unused.add(orderId);
        }
        sql_unused = sql_unused + " limit 1 for update";
        List virtualCards_unused = this.baseDao.executeQuery(VirtualCard.class, sql_unused, paramList_unused);
        return virtualCards_unused;
    }
}

