package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.MobleGamesDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.MobileGameExtInfo;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zy on 2016/3/14.
 */
public class MobileGameExtInfoDaoImpl extends BaseDaoImpl implements MobileGameExtInfoDao {

    @Override
    public List<MobleGamesDTO> getMoibleGameExtInfos(int pageNo,int pageSize,String gameId,String gameNo,String gameName,String status,String orderBy) {

        String sql = "SELECT  games.seqId, games.gameId, games.gameNo, games.gameName, games.gameDesc, games.gameType, " +
                "games.runStatus, games.displayOrder, games.status, games.remark, games.inputBy, games.inputTime, " +
                "games.editBy, games.editTime, games.clientType, games.simpleName, games.gameFeature, games.playLevel, " +
                "games.picUrl, games.smallPicUrl, games.isNew, games.isHot,games.isFirstPublish, games.recommendIndex, games.runType," +
                " games.appSize, games.downloadNum, games.summary, games.packageName, games.hasGift,games.mobileGameType, " +
                " mobilegameextinfo.mobileGameClass,mobilegameextinfo.seqid as mobileSeqId, " +
                "mobilegameextinfo.mobileGameFeature, mobilegameextinfo.mobileGameTheme, " +
                "mobilegameextinfo.mobileGameLable " +
                "from games \n" +
                " LEFT JOIN mobilegameextinfo  on games.gameId = mobilegameextinfo.mobileGameId where 1=1 and games.clientType = 3 ";

        ArrayList<Object> param = new ArrayList<Object>();
        if(pageNo<1)
            pageNo =1;
        if(pageSize<1)
            pageSize = 20;

        if(StringUtils.isNotEmpty(gameNo)){
            sql+=" and gameNo = ? ";
            param.add(gameNo);
        }

        if(StringUtils.isNotEmpty(gameId)){
            sql+=" and gameId = ? ";
            param.add(gameId);
        }

        if(StringUtils.isNotEmpty(gameName)){
            sql+=" and gameName like ? ";
            param.add("%" + gameName + "%");
        }

        if(StringUtils.isNotEmpty(status)){
            sql+=" and status = ? ";
            param.add(status);
        }

        if(StringUtils.isNotEmpty(orderBy)){
            sql += " order by "+orderBy;
        }
        if(pageSize>0){
            sql +=" limit ?,?";
            param.add((pageNo-1)*pageSize);
            param.add(pageSize);
        }
        List<MobleGamesDTO> mobleGamesDTOs = findBySql(MobleGamesDTO.class, sql,param);

        return mobleGamesDTOs;
    }

    @Override
    public void updateMobileGameInfo(Games games, MobileGameExtInfo extInfo) {
        updateById(games);
        if(extInfo.getSeqid()==null||extInfo.getSeqid()==0){
            extInfo.setMobileGameId(games.getGameId());
            insert(extInfo);
        }else {
            updateById(extInfo);
        }
    }

    @Override
    public void addMobileGameInfo(Games games, MobileGameExtInfo extInfo) {
        insert(games);
        insert(extInfo);
    }

}
