package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.ResponsiblePeople;

import java.util.List;

/**
 * @author hezhong
 */
public class ResponsiblePeopleBoImpl implements ResponsiblePeopleBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<ResponsiblePeople> find(ResponsiblePeople people, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);

        return baseDao.findByObject(ResponsiblePeople.class, people, page);
    }

    @Override
    public int count(ResponsiblePeople people) {
        return baseDao.count(people);
    }

    @Override
    public ResponsiblePeople findById(Integer seqid) {
        return baseDao.findById(ResponsiblePeople.class, seqid);
    }

    @Override
    public void insert(ResponsiblePeople people) {
        baseDao.insert(people);
    }

    @Override
    public void update(ResponsiblePeople people) {
        baseDao.updateById(people);
    }

    @Override
    public void delete(Integer seqid) {
        baseDao.deleteById(ResponsiblePeople.class, seqid);
    }


}
