package com.xunlei.niux.data.vipgame.bo;

import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameCategory;


public class GameCategoryBoImpl extends BaseDaoImpl implements GameCategoryBo{
	 private BaseDao baseDao;
		
		public BaseDao getBaseDao() {
			return baseDao;
		}

		public void setBaseDao(BaseDao baseDao) {
			this.baseDao = baseDao;
		}

		@Override
		public int count(GameCategory gc) {
			return baseDao.count(gc);
		}

		@Override
		public void deleteById(long id) {
			baseDao.deleteById(GameCategory.class, id);
		}
		
		public int count(String sql,Object [] args){
		    return getJdbcTemplate().queryForInt(sql, args);
		}

		@Override
		public List<GameCategory> find(GameCategory gc, int pageNo,
				int pageSize) {
			Page page = new Page();
			page.setPageNo(pageNo);
			page.setPageSize(pageSize);
			return baseDao.findByObject(GameCategory.class, gc, page);
		}
		 



		@Override
		public GameCategory findById(long id) {
			return baseDao.findById(GameCategory.class, id);
		}

		@Override
		public void insert(GameCategory gc) {
			 baseDao.insert(gc);
		}

		@Override
		public void update(GameCategory gc) {
			baseDao.updateById(gc);
		}
		public  List findBySql(Class clazz, String preSql, List paramList) {
			return baseDao.findBySql(clazz, preSql, paramList);
		}


}
