package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicOperatorsGamesKpi;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by zy on 2016/6/23.
 */
public class VicOperatorsBoImpl implements VicOperatorsBo {

    private static SimpleDateFormat month = new SimpleDateFormat("yyyy-MM");

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<VicOperatorsGamesKpi> getInGamesKpi(Long operatorId,String gameId) {
        String sql = "select * from vic_operators_games_kpi where 1=1 ";
        List<Object> list = new ArrayList<Object>();
        if(operatorId>0){
            sql += " and operatorId = ?";
            list.add(operatorId);
        }
        if(StringUtils.isNotEmpty(gameId)){
            sql += " and gameId = ?";
            list.add(gameId);
        }

        sql += " and kpiTime = '"+month.format(new Date())+"' ";
        sql += " order by createTime desc ";

        List<VicOperatorsGamesKpi> gamesKpis = baseDao.findBySql(VicOperatorsGamesKpi.class, sql, list);
        return gamesKpis;
    }

    @Override
    public List<Games> getOutGamesKpi(Long operatorId,String gameId) {

        String sql = " select * from games where 1=1 ";
        List<Object> list = new ArrayList<Object>();
        if(StringUtils.isNotEmpty(gameId)){
            sql +=" and gameId = ? ";
            list.add(gameId);
        }

        sql += " order by editTime desc  limit 50 ";
        return baseDao.findBySql(Games.class,sql,list);
    }

    @Override
    public void out2in(Long operatorId, String[] gameIds) {
        if(gameIds==null||gameIds.length==0){
            return;
        }
        for(String gameId : gameIds){
            VicOperatorsGamesKpi kpi = new VicOperatorsGamesKpi();
            kpi.setEditTime(DateUtil.getOrderTime());
            kpi.setOperatorId(operatorId);
            kpi.setStatus(1);
            kpi.setGameId(gameId);
            kpi.setCreateTime(DateUtil.getOrderTime());
            baseDao.insert(kpi);
        }

    }

    @Override
    public void in2out(Long operatorId, String[] seqIds) {
        if(seqIds==null||seqIds.length==0){
            return;
        }
        String sql = "delete from vic_operators_games_kpi where operatorId = ? and seqId in (";
        List<Object> list = new ArrayList<Object>();
        list.add(operatorId);
        for(String gameId : seqIds){
            sql += "?,";
            list.add(gameId);
        }
        sql = sql.substring(0,sql.length()-1)+" ) and status=1 ";
        baseDao.execute(sql,list);
    }

    @Override
    public List<Games> getSelfGames(String trueName) {
        String sql = "select * from games where gameId in (select distinct gameId from vic_operators_games_kpi vogk left join vic_operators vo on vo.seqId=vogk.operatorId where vo.name= ? ) ";
        List<Object> list = new ArrayList<Object>(1);
        list.add(trueName);
        return  baseDao.findBySql(Games.class,sql,list);
    }
}
